package ru.yandex.travel.hotels.searcher.services.cache.expedia;

import javax.validation.Valid;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.yt_lucene_index.SwitchableYtLuceneIndexParams;
import ru.yandex.travel.yt_lucene_index.YtLuceneIndexParams;

@ConfigurationProperties(value = "yt.cache.expedia", ignoreUnknownFields = false)
@Data
@Validated
public class ExpediaYtCacheProperties {
    @Valid
    private YtLuceneIndexParams propertyPansionsParams;

    @Valid
    private SwitchableYtLuceneIndexParams hotelCoordinatesParams;
}
