package ru.yandex.travel.hotels.searcher.services.cache.travelline.availability;

import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.bolts.collection.Tuple3;

public interface AvailabilityRepository extends CacheRepository<Tuple3<String, LocalDate, LocalDate>,
        CachedOfferAvailability> {
    CompletableFuture<List<Tuple3<String, LocalDate, LocalDate>>> listAvailabilityKeysForOffersBeforeDate(LocalDate date,
                                                                                                          CacheTransaction transaction);
}
