package ru.yandex.travel.hotels.searcher.services.cache.travelline.availability;

import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface CacheRepository<K, V> {
    CompletableFuture<V> get(K id, CacheTransaction transaction);

    CompletableFuture<V> put(V item, CacheTransaction transaction);

    CompletableFuture<Void> remove(List<K> ids, CacheTransaction transaction);
}
