package ru.yandex.travel.hotels.searcher.services.cache.travelline.availability;

import java.time.LocalDate;
import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.travelline.TravellineClient;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelOfferAvailability;
import ru.yandex.travel.hotels.proto.ERequestClass;

@RequiredArgsConstructor
public class DirectTravellineAvailabilitySearcher implements TravellineAvailabilitySearcher {
    private final TravellineClient backgroundThrottledTravellineClient;
    private final TravellineClient interactiveThrottledTravellineClient;

    @Override
    public CompletableFuture<HotelOfferAvailability> lookupOffers(String taskId, String hotelId, LocalDate checkin, LocalDate checkout,
                                                                  ERequestClass requestClass,
                                                                  CallContext callContext, String requestId) {
        TravellineClient client;
        switch (requestClass) {
            case RC_INTERACTIVE:
            case RC_CALENDAR:
                client = interactiveThrottledTravellineClient;
                break;
            case RC_BACKGROUND:
                client = backgroundThrottledTravellineClient;
                break;
            default:
                return CompletableFuture.failedFuture(new AssertionError());
        }
        if (callContext.getTestContext() != null) {
            client = client.withCallContext(callContext);
        }
        return client.findOfferAvailability(hotelId, checkin, checkout, requestId);
    }
}
