package ru.yandex.travel.hotels.searcher.services.cache.travelline.availability;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface InventoryRepository extends CacheRepository<String, CachedHotelInventory> {
    CompletableFuture<Map<String, Long>> getInventoryVersion(CacheTransaction transaction);
    CompletableFuture<List<String>> listHotelsActualizedBefore(Instant instant, CacheTransaction transaction);

}
