package ru.yandex.travel.hotels.searcher.services.cache.travelline.availability;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

import ru.yandex.bolts.collection.Tuple3;

public interface L2Cache {
    CompletableFuture<Map<String, Long>> getInventoryVersions(CacheTransaction transaction);

    CompletableFuture<CachedHotelInventory> getInventory(String hotelId, CacheTransaction transaction);

    CompletableFuture<CachedHotelInventory> putInventory(CachedHotelInventory inventory, CacheTransaction transaction);

    CompletableFuture<Void> removeInventories(List<String> hotelIds, CacheTransaction transaction);

    CompletableFuture<CachedOfferAvailability> getAvailability(String taskId, String hotelId, LocalDate checkin, LocalDate checkout,
                                                               CacheTransaction transaction);

    CompletableFuture<CachedOfferAvailability> putAvailability(CachedOfferAvailability availability,
                                                               CacheTransaction transaction);

    CompletableFuture<Void> removeAvailabilities(List<Tuple3<String, LocalDate, LocalDate>> keys,
                                                 CacheTransaction transaction);

    CompletableFuture<List<String>> listHotelsActualizedBefore(Instant instant, CacheTransaction transaction);

    CompletableFuture<List<Tuple3<String, LocalDate, LocalDate>>> listAvailabilityKeysForOffersBeforeDate(LocalDate date,
                                                                                                          CacheTransaction transaction);

    <R> CompletableFuture<R> transactionally(Function<CacheTransaction, CompletableFuture<R>> futureToCall);

    default CompletableFuture<CachedHotelInventory> getInventory(String hotelId) {
        return transactionally(t -> getInventory(hotelId, t));
    }

    default CompletableFuture<Map<String, Long>> getInventoryVersions() {
        return transactionally(this::getInventoryVersions);
    }

    default CompletableFuture<CachedHotelInventory> putInventory(CachedHotelInventory inventory) {
        return transactionally(t -> putInventory(inventory, t));
    }

    default CompletableFuture<Void> removeInventories(List<String> hotelIds) {
        return transactionally(t -> removeInventories(hotelIds, t));
    }

    default CompletableFuture<Void> removeInventory(String hotelId) {
        return removeInventories(List.of(hotelId));
    }

    default CompletableFuture<Void> removeInventory(String hotelId, CacheTransaction transaction) {
        return removeInventories(List.of(hotelId), transaction);
    }

    default CompletableFuture<CachedOfferAvailability> getAvailability(String taskId, String hotelId, LocalDate checkin,
                                                                       LocalDate checkout) {
        return transactionally(t -> getAvailability(taskId, hotelId, checkin, checkout, t));
    }

    default CompletableFuture<CachedOfferAvailability> putAvailability(CachedOfferAvailability availability) {
        return transactionally(t -> putAvailability(availability, t));
    }

    default CompletableFuture<Void> removeAvailabilities(List<Tuple3<String, LocalDate, LocalDate>> keys) {
        return transactionally(t -> removeAvailabilities(keys, t));
    }

    default CompletableFuture<Void> removeAvailability(String hotelId, LocalDate checkin, LocalDate checkout) {
        return transactionally(t -> removeAvailabilities(List.of(Tuple3.tuple(hotelId, checkin, checkout)), t));
    }

    default CompletableFuture<Void> removeAvailability(String hotelId, LocalDate checkin, LocalDate checkout,
                                                       CacheTransaction transaction) {
        return removeAvailabilities(List.of(Tuple3.tuple(hotelId, checkin, checkout)), transaction);
    }

    default CompletableFuture<List<String>> listHotelsActualizedBefore(Instant instant) {
        return transactionally(t -> listHotelsActualizedBefore(instant, t));
    }

    default CompletableFuture<List<Tuple3<String, LocalDate, LocalDate>>> listAvailabilityKeysForOffersBeforeDate(LocalDate date) {
        return transactionally(t -> listAvailabilityKeysForOffersBeforeDate(date, t));
    }
}
