package ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.inmemory;

import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import ru.yandex.bolts.collection.Tuple3;
import ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.AvailabilityRepository;
import ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.CacheTransaction;
import ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.CachedOfferAvailability;

public class InmemoryAvailabilityRepository
        extends InmemoryCacheRepository<Tuple3<String, LocalDate, LocalDate>, CachedOfferAvailability>
        implements AvailabilityRepository {
    @Override
    protected Tuple3<String, LocalDate, LocalDate> mapKey(CachedOfferAvailability entity) {
        return Tuple3.tuple(entity.getHotelId(), entity.getCheckinDate(), entity.getCheckoutDate());
    }

    @Override
    public CompletableFuture<List<Tuple3<String, LocalDate, LocalDate>>> listAvailabilityKeysForOffersBeforeDate(LocalDate date, CacheTransaction transaction) {
        return CompletableFuture.completedFuture(
                cacheMap.keySet().stream().filter(availability -> availability.get3().isBefore(date)).collect(Collectors.toList()));
    }
}
