package ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.inmemory;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.CacheTransaction;
import ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.CachedHotelInventory;
import ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.InventoryRepository;

public class InmemoryInventoryRepository extends InmemoryCacheRepository<String, CachedHotelInventory> implements InventoryRepository {

    @Override
    protected String mapKey(CachedHotelInventory entity) {
        return entity.getHotelId();
    }

    @Override
    public CompletableFuture<Map<String, Long>> getInventoryVersion(CacheTransaction transaction) {
        return CompletableFuture.completedFuture(cacheMap.entrySet().stream()
                .collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().getVersion())));
    }

    @Override
    public CompletableFuture<List<String>> listHotelsActualizedBefore(Instant instant, CacheTransaction transaction) {
        return CompletableFuture.completedFuture(cacheMap.entrySet().stream()
                .filter(e -> e.getValue().getActualizationTimestamp().isBefore(instant))
                .map(Map.Entry::getKey)
                .collect(Collectors.toList()));
    }
}
