package ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.yt;

import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.yt.ConnectionFactory;
import ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.CacheTransaction;
import ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.TransactionSupplier;
import ru.yandex.yt.rpcproxy.ETransactionType;
import ru.yandex.yt.ytclient.proxy.ApiServiceTransactionOptions;
import ru.yandex.yt.ytclient.proxy.YtClient;

@RequiredArgsConstructor
public class YtTransactionSupplier implements TransactionSupplier {
    private final ConnectionFactory connectionFactory;
    private final String clusterName;


    @Override
    public CompletableFuture<CacheTransaction> startTransaction() {
        ApiServiceTransactionOptions options = new ApiServiceTransactionOptions(ETransactionType.TT_TABLET);
        options.setSticky(true);
        YtClient client = connectionFactory.getClientForCluster(clusterName);
        return client.waitProxies()
                .thenCompose(ignored -> client.startTransaction(options).thenApply(YtTransaction::new));
    }
}
