package ru.yandex.travel.hotels.searcher.services.cache.travelline.hotels;

import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.travelline.TravellineClient;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelInfo;
import ru.yandex.travel.hotels.searcher.services.cache.Actualizable;
import ru.yandex.travel.hotels.searcher.services.cache.CachedActualizable;

@RequiredArgsConstructor
public class DirectTravellineHotelDataSearcher implements TravellineHotelDataSearcher {
    private final TravellineClient client;

    @Override
    public CompletableFuture<Actualizable<HotelInfo>> getHotelData(String taskId, String hotelCode,
                                                                   CallContext callContext,
                                                                   String requestId) {
        TravellineClient client = this.client;
        if (callContext.getTestContext() != null) {
            client = client.withCallContext(callContext);
        }
        return client.getHotelInfo(hotelCode, requestId).thenApply(CachedActualizable::oneValue);
    }
}
