package ru.yandex.travel.hotels.searcher.yt;

import com.google.common.base.Strings;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import ru.yandex.travel.commons.yt.ClientReplicatedYtProperties;
import ru.yandex.travel.commons.yt.YtClusterPropertiesInterface;

public class YtPropertiesValidator implements Validator {
    @Override
    public boolean supports(Class<?> clazz) {
        return clazz == ClientReplicatedYtProperties.class;
    }

    @Override
    public void validate(Object target, Errors errors) {
        ClientReplicatedYtProperties config = (ClientReplicatedYtProperties) target;
        if (config.getMinWritesToContinue() < 0) {
            errors.rejectValue("minWritesToContinue", "quorum.small", "quorum cannot be negative");
            return;
        }
        if (config.getMinWritesToContinue() > config.getSinkClusters().size()) {
            errors.rejectValue("minWritesToContinue", "quorum.large", "quorum cannot exceed total number of clusters");
            return;
        }
        errors.pushNestedPath("clusters");
        for (String clusterName : config.getSinkClusters()) {
            YtClusterPropertiesInterface clusterConfig = config.getClusterConfigFor(clusterName);
            if (Strings.isNullOrEmpty(clusterConfig.getUser())) {
                errors.reject("user.empty", "user is not defined for cluster '" + clusterName + "';");
            }
            if (Strings.isNullOrEmpty(clusterConfig.getToken())) {
                errors.reject("token.empty", "token is not defined for cluster '" + clusterName + "'");
            }
            if (Strings.isNullOrEmpty(clusterConfig.getTablePath())) {
                errors.reject("tablePath.empty", "table path is not defined for cluster '" + clusterName + "'");
            }
        }
        errors.popNestedPath();
    }
}
