RECURSE_FOR_TESTS(src/test)

JAVA_PROGRAM(travel-hotels-searcher)

JDK_VERSION(11)

WITH_KOTLIN()
WITH_KOTLINC_ALLOPEN(
    preset=spring
)

INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

OWNER(g:travel-hotels)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

PEERDIR(
    contrib/java/com/github/luben/zstd-jni/1.3.4-3
    contrib/java/com/google/protobuf/protobuf-java-util
    contrib/java/com/lmax/disruptor
    contrib/java/org/asynchttpclient/async-http-client
    contrib/java/org/apache/logging/log4j/log4j-jcl

    iceberg/inside-yt
    travel/hotels/lib/java/commons
    travel/hotels/lib/java/partner_parsers
    travel/hotels/proto2
    travel/hotels/proto/offer_invalidation
    travel/hotels/proto/offerbus_messages
    travel/hotels/proto/search_flow_offer_data
    travel/library/java/commons
    travel/library/java/ha-grpc-client
    travel/library/java/spring-boot-skeleton
    travel/library/java/yt-lucene-index
    travel/orders/proto/services/orders
    travel/proto
    yt/java/ytclient
    contrib/java/it/unimi/dsi/fastutil
    contrib/java/org/apache/logging/log4j/log4j-jcl
    contrib/java/com/github/ben-manes/caffeine/caffeine
    contrib/java/org/mockito/kotlin/mockito-kotlin/4.0.0
    contrib/java/org/springframework/boot/spring-boot-starter-validation
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/hotels/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/searcher.py
    CUSTOM_PROPERTY appName travel-hotels-searcher
    CUSTOM_PROPERTY mainClass ru.yandex.travel.hotels.searcher.SearcherApplication
)

NO_LINT()

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/com/lmax/disruptor/3.4.2
)

END()
