# -*- coding: utf-8 -*-

import os
from functools import partial

from nile.api.v1 import (
    extractors as ne,
    aggregators as na,
    filters as nf,
    statface as ns,
    Record,
    cli
)

from nile.files import LocalFile

from qb2.api.v1 import (
    extractors as se,
    filters as sf,
    resources as sr
)

directory = os.environ['JWD']
os.sys.path.append(directory)

FIELDS_MAP = "FieldsMap"
REDIRS = "//logs/travel-redir-log/1d"

FIELDS= ("price", "timestamp", "operator_id")

def make_vals(records):
        for rec in records:
            values = [rec.reqid]
            for field in FIELDS:
                values.append("=".join([field, str(rec[field])]))
            result = dict(key="y"+rec.uid,
                      subkey=" stat_queries",
                      value="\t".join(values))
            yield Record(**result)


@cli.statinfra_job
def make_job(job, options, nirvana, statface_client):
    """Standart function according to Statistics conventions,
    see https://clubs.at.yandex-team.ru/statistics/1143"""

    dates = options.dates
    if len(dates) > 1:
        suffix = "{first}_{last}".format(first=dates[0], last=dates[-1])
    else:
        suffix = dates[0]

    job_root = nirvana.directories[0] if nirvana.directories else DEFAULT_DIR

    job = job.env(
        # files=[LocalFile(os.path.join(directory, 'utils.py'))],
        templates=dict(job_root=job_root,
                       suffix=suffix
                       )
    )

    output_table = nirvana.output_tables[0] if nirvana.output_tables else '$job_root/redirs_to_abt/$suffix'

    job.table('{}/@dates'.format(REDIRS))\
	.filter(nf.custom(lambda x: x["Source"] == "serp", FIELDS_MAP))\
	.filter(nf.custom(lambda x: x["Medium"] == "booking_form", FIELDS_MAP))\
	.filter(nf.custom(lambda x: bool(x["YandexUid"]), FIELDS_MAP))\
	.project("timestamp",
		uid=ne.custom(lambda x: x["YandexUid"], FIELDS_MAP),
		reqid=ne.custom(lambda x: x["ReqId"], FIELDS_MAP),
		price=ne.custom(lambda x: x["Price"], FIELDS_MAP),
		operator_id=ne.custom(lambda x: x["OperatorId"], FIELDS_MAP)
		)\
	.map(make_vals)\
	.put(output_table)

    return job


if __name__ == "__main__":
    cli.run()
