import datetime as dt
from nile.api.v1 import Record

PROD_DIR = 'home/travel/prod'


def string_to_date(date_string):
    date_string = date_string[:10]
    return dt.datetime.strptime(date_string, "%Y-%m-%d").date()


def timestamp_to_date(ts):
    return dt.datetime.utcfromtimestamp(ts).date()


def make_vals(records, fields):
    for rec in records:
        values = [rec.reqid]
        for field in fields:
            values.append("=".join([field, str(rec[field])]))
        result = dict(key="y"+rec.icookie,
                      subkey=" stat_queries",
                      value="\t".join(values))
        yield Record(**result)
