# -*- coding: UTF-8 -*-
"""HOTELS-3719
   The script exports partner redirects and bookings of the logged-in users for UGC"""

import argparse
import os
from nile.api.v1 import (
    clusters,
    extractors as ne,
    filters as nf,
)

ORDERS = '//home/travel/prod/cpa/hotels/orders'
REDIR_LOGS = '//logs/travel-redir-log/1d'
SEARCHER = '//home/logfeller/logs/travel-hotels-search-result-log/1d'
FIELDS_MAP = 'FieldsMap'
DEFAULT_TARGET_DIR = '//home/travel/prod/to_ugc'

REDIRECT_TYPES = {"full_offers": "redirect_with_search",
                  "quick_offers": "default_redirect"}


def handle_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-d', '--date', required=True)
    parser.add_argument('-t', '--target', help='target path', default=DEFAULT_TARGET_DIR)
    args = parser.parse_args()
    return args


def main():
    args = handle_args()
    date = args.date
    target_dir = args.target

    cluster = clusters.yt.Hahn(token=os.environ['YT_TOKEN']
                               ).env(templates=dict(target=target_dir,
                                                    redir=REDIR_LOGS,
                                                    searcher=SEARCHER,
                                                    date=date),
                                     )
    job = cluster.job()

    searcher = job.table('$searcher/$date') \
        .project(check_out='CheckOutDate',
                 travel_reqid='SearchOfferReqId')

    redirs = job.table('$redir/$date') \
        .project(permalink=ne.custom(lambda x: x["Permalink"], FIELDS_MAP),
                 puid=ne.custom(lambda x: x["PassportUid"], FIELDS_MAP),
                 travel_reqid=ne.custom(lambda x: x["SearcherReqId"], FIELDS_MAP),
                 offer_type=ne.custom(lambda x: x["Content"], FIELDS_MAP),
                 timestamp="unixtime") \
        .filter(nf.not_(nf.equals("puid", ""))) \
        .join(searcher, by="travel_reqid") \
        .project('check_out',
                 'timestamp',
                 reason=ne.custom(lambda x: REDIRECT_TYPES.get(
                     x, "unknown_redirect"), "offer_type"),
                 permalink=ne.custom(int, "permalink"),
                 puid=ne.custom(int, "puid"))

    orders = job.table(ORDERS) \
        .filter(nf.equals("check_in", date)) \
        .filter(nf.not_(nf.equals("status", "cancelled"))) \
        .filter(nf.not_(nf.equals("label_passport_uid", ""))) \
        .project('check_out',
                 timestamp="created_at",
                 reason=ne.const("booking"),
                 permalink=ne.custom(int, "label_permalink"),
                 puid=ne.custom(int, 'label_passport_uid'),
                 )

    job.concat(redirs, orders) \
        .put('$target/$date')

    job.run()


if __name__ == "__main__":
    main()
