# -*- coding: utf-8 -*-

import os
from functools import partial

import nile
from nile.api.v1 import (
    extractors as ne,
    aggregators as na,
    filters as nf,
    statface as ns,
    Record,
    cli
)

from nile.files import LocalFile

from qb2.api.v1 import (
    extractors as se,
    filters as sf,
    resources as sr
)

directory = os.environ['JWD']
os.sys.path.append(directory)
from common import BAD_TEST_IDS, TRAVEL_RUBRICS, add_totals, norm_rubric, safe_int, WizardType

REPORT_TITLE = u'Отельная карусель на СЕРПe (кэш-хит)'
REPORT_PATH = "Adhoc/Hotels/Travel-carousel-cache_hit_miss"
REPORT_YAML_CONFIG = "carousel_cache_hit/carousel_cache_hit.yaml"
DEFAULT_DIR = "home/travel/analytics"
FIELDS = ("region", "rubric")

ELEM_PATHS = ("/tabs/list/showcase/item/topic", "/showcase/item/thumb")

add_totals_curried = partial(
    add_totals, fields=FIELDS, special_cases={"rubric": 0})

def ratio(elems, pos=6):
   try:
   	filtered = [safe_int(elem["price"])>0 for elem in elems if int(elem["pos"])<pos]
   	total = len(filtered)
   	if total:
   		return float(sum(filtered))/total
  	else:
		return 0.
   except KeyError:
	return 0.

ratio_10 = partial(ratio, pos=10)
ratio_20 = partial(ratio, pos=20)

@cli.statinfra_job
def make_job(job, options, nirvana, statface_client):
    """Standart function according to Statistics conventions,
    see https://clubs.at.yandex-team.ru/statistics/1143"""

    report = ns.StatfaceReport() \
        .from_yaml_config(REPORT_YAML_CONFIG)\
        .path(REPORT_PATH)\
        .title(REPORT_TITLE.encode('utf8'))\
        .scale("daily")\
        .client(statface_client)

    dates = options.dates
    if len(dates) > 1:
        suffix = "{first}_{last}".format(first=dates[0], last=dates[-1])
    else:
        suffix = dates[0]

    job_root = nirvana.directories[0] if nirvana.directories else DEFAULT_DIR

    job = job.env(
	files=[LocalFile(os.path.join(directory, 'common.py'))],
        templates=dict(job_root=job_root,
                       suffix=suffix
                       )
    )

    input_table = nirvana.input_tables[0] if nirvana.input_tables else '$job_root/user_sessions/@dates'
    output_table = nirvana.output_tables[0] if nirvana.output_tables else '$job_root/carousel_cache_hit/$suffix'

    #.filter(nf.custom(lambda blocks: not any(elem["path"].startswith("/tabs/list") for elem in blocks.get(WizardType.Carousel, [])), "blocks"))\

    job.table(input_table)\
	.filter(nf.custom(lambda test_ids: not BAD_TEST_IDS.intersection(test_ids), "test_ids"))\
        .filter(nf.custom(lambda x: x.get(WizardType.Carousel) is not None, "blocks"))\
        .project("region",
                 "reqid",
                 fielddate=ne.custom(lambda x: x.split("T")[
                     0], "time_isoformatted"),
                 rubric=ne.custom(lambda search_props: norm_rubric(search_props.get("Rubrics", "")), "search_props"),
		 items=ne.custom(lambda elems: [elem for elem in elems[WizardType.Carousel] if elem["path"] in ELEM_PATHS], "blocks")
                 )\
	.project(ne.all(),
                 present_10=ne.custom(lambda x: len(x)>9, "items"),
                 present_6=ne.custom(lambda x: len(x)>5, "items"),
		 ratio_6=ne.custom(ratio, "items"),
		 ratio_10=ne.custom(ratio_10, "items"),
		 #ratio_20=ne.custom(ratio_20, "items")
		)\
        .map(add_totals_curried)\
        .groupby("fielddate", *FIELDS)\
        .aggregate(cnt=na.count(),
                  present_10=na.count(predicate=nf.equals("present_10", True)),
                  present_6=na.count(predicate=nf.equals("present_6", True)),
		  more_than_0=na.count(predicate=nf.custom(lambda x: x>0, "ratio_6")),
		  more_than_20=na.count(predicate=nf.custom(lambda x: x>0.2, "ratio_6")),
		  more_than_40=na.count(predicate=nf.custom(lambda x: x>0.4, "ratio_6")),
		  more_than_50=na.count(predicate=nf.custom(lambda x: x>0.5, "ratio_6")),
		  more_than_60=na.count(predicate=nf.custom(lambda x: x>0.6, "ratio_6")),
		  more_than_80=na.count(predicate=nf.custom(lambda x: x>0.8, "ratio_6")),
		  more_than_50_top_10=na.count(predicate=nf.custom(lambda x: x>0.5, "ratio_10")),
		  more_than_60_top_10=na.count(predicate=nf.custom(lambda x: x>0.6, "ratio_10")),
		  more_than_70_top_10=na.count(predicate=nf.custom(lambda x: x>0.7, "ratio_10")),
		  more_than_80_top_10=na.count(predicate=nf.custom(lambda x: x>0.8, "ratio_10")),
		  more_than_90_top_10=na.count(predicate=nf.custom(lambda x: x>0.9, "ratio_10")),
       		  #more_than_50_top_20=na.count(predicate=nf.custom(lambda x: x>0.5, "ratio_20")),
		  #more_than_60_top_20=na.count(predicate=nf.custom(lambda x: x>0.6, "ratio_20")),
		  #more_than_70_top_20=na.count(predicate=nf.custom(lambda x: x>0.7, "ratio_20")),
		  #more_than_80_top_20=na.count(predicate=nf.custom(lambda x: x>0.8, "ratio_20")),
		  #more_than_90_top_20=na.count(predicate=nf.custom(lambda x: x>0.9, "ratio_20"))
		  )\
         .put(output_table)\
        .publish(report)

    return job


if __name__ == "__main__":
    cli.run()
