# -*- coding: utf-8 -*-

import os
from functools import partial

import nile
from nile.api.v1 import (
    extractors as ne,
    aggregators as na,
    filters as nf,
    statface as ns,
    Record,
    cli
)

from nile.files import LocalFile


from qb2.api.v1 import (
    extractors as se,
    filters as sf,
    resources as sr
)

directory = os.environ['JWD']
os.sys.path.append(directory)
from common import DEFAULT_DIR, BAD_TEST_IDS, TRAVEL_RUBRICS, add_totals, norm_rubric, safe_int, WizardType


REPORT_TITLE = u'Отельная карусель на СЕРПe. Открытие попапа'
REPORT_PATH = "Adhoc/Hotels/Travel-carousel-position"
REPORT_YAML_CONFIG = "carousel_clicks/carousel.yaml"
FIELDS = ("device", "region", "rubric", "request_after_carousel_click")
CAROUSEL_ITEMS = ("/parallel/result/wiz/companies/map/upper/showcase/item/thumb",  "/parallel/result/wiz/companies/travel_map/upper/tabs/list/showcase/item/topic", "/parallel/result/wiz/companies/travel_map/upper/tabs/list/showcase/item/bcard/title", "/parallel/result/wiz/companies/travel_map/upper/tabs/list/showcase/item/bcard/price")

add_totals_curried = partial(
    add_totals, fields=FIELDS, special_cases={"rubric": 0})

def carousel_items(records):
    for rec in records:
        result = dict(device=rec.device,
                            region=rec.region,
                            rubric=rec.rubric,
                            fielddate=rec.fielddate,
                            reqid=rec.reqid,
			    request_after_carousel_click=rec.request_after_carousel_click
                            )
	positions = []
        for click in rec.clicks:
		if click["path"] in CAROUSEL_ITEMS:
		    pos = click.get("item_n")
                    result["position"] = safe_int(pos)
        	    yield Record(**result)


@cli.statinfra_job
def make_job(job, options, nirvana, statface_client):
    """Standart function according to Statistics conventions,
    see https://clubs.at.yandex-team.ru/statistics/1143"""

    report = ns.StatfaceReport() \
        .from_yaml_config(REPORT_YAML_CONFIG)\
        .path(REPORT_PATH)\
        .title(REPORT_TITLE.encode('utf8'))\
        .scale("daily")\
        .client(statface_client)

    dates = options.dates
    if len(dates) > 1:
        suffix = "{first}_{last}".format(first=dates[0], last=dates[-1])
    else:
        suffix = dates[0]

    job_root = nirvana.directories[0] if nirvana.directories else DEFAULT_DIR

    job = job.env(
	files=[LocalFile(os.path.join(directory, 'common.py'))],
        templates=dict(job_root=job_root,
                       suffix=suffix
                       )
    )

    input_table = nirvana.input_tables[0] if nirvana.input_tables else '$job_root/user_sessions/@dates'
    output_table = nirvana.output_tables[0] if nirvana.output_tables else '$job_root/carousel_clicks/$suffix'

    job.table(input_table)\
	.filter(nf.custom(lambda test_ids: not BAD_TEST_IDS.intersection(test_ids), "test_ids"))\
        .filter(nf.custom(lambda x: x.get(WizardType.Carousel) is not None, "blocks"))\
        .project("region",
                 "device",
                 "clicks",
		 "reqid",
                 fielddate=ne.custom(lambda x: x.split("T")[
                     0], "time_isoformatted"),
                 request_after_carousel_click=ne.const("before"),
                 rubric=ne.custom(lambda search_props: norm_rubric(search_props.get("Rubrics", "")), "search_props"))\
        .map(carousel_items)\
        .map(add_totals_curried)\
        .groupby("fielddate", *FIELDS)\
        .aggregate(reqid_count=na.count_distinct("reqid"),
		   click_count=na.count(),
		   median_pos=na.median("position"),
		   avg_pos=na.mean("position"))\
        .put(output_table)\
        .publish(report)

    return job


if __name__ == "__main__":
    cli.run()
