# -*- coding: utf-8 -*-

import os
from copy import copy
from functools import partial

from nile.api.v1 import (
    extractors as ne,
    aggregators as na,
    filters as nf,
    statface as ns,
    Record,
    cli
)

from nile.files import LocalFile

from qb2.api.v1 import (
    extractors as se,
    filters as sf,
    resources as sr
)

directory = os.environ['JWD']
os.sys.path.append(directory)
from common import BAD_TEST_IDS, TRAVEL_RUBRICS, DEFAULT_DIR, add_totals, norm_rubric, WizardType, get_path, is_one_org

REPORT_TITLE = u'Отельный 1Org на СЕРПе: клики перед переходом к партнеру'
REPORT_PATH = "Adhoc/Hotels/TravelOneOrg_before_partners"
REPORT_YAML_CONFIG = "clicks_before_result_click/before_result.yaml"

TRAVEL_1ORG = WizardType.TravelOneOrg

FIELDS = ("device", "region", "rubric", "click_path", "is_dynamic")

add_totals_curried = partial(
    add_totals, fields=FIELDS, special_cases={"rubric": 0})

def clicks_filter(records):
    """Make flat table of clicks, only that happened before partner redirect"""
    for rec in records:
        proto_result = dict(device=rec.device,
		      region=rec.region,
                      rubric=rec.rubric,
		      fielddate=rec.fielddate,
		      reqid=rec.reqid)
        result_delay = -1
	for click in rec.clicks:
            if get_path(click["path"]) == "travel_result":
	        delay = click["delay"]
	        if delay > result_delay:
		    result_delay = delay
        if result_delay > -1:
               for click in rec.clicks:
	           if click["delay"] <  result_delay:
                       result = copy(proto_result)
                       result["result_delay"] = result_delay - click["delay"]
 		       result["dwelltime"] = click["dwelltime"]
		       result["click_path"] = get_path(click["path"]) or "other"
                       result["is_dynamic"]=str(click["is_dynamic"])
     		       yield Record(**result)

def clicks_reducer(groups):
    for key, records in groups:
        result = defaultdict(int, dict(device=key.device,
		      region=key.region,
                      rubric=key.rubric,
		      fielddate=key.fielddate))
	for record in records:
	   result_delay = -1
	   for click in record.clicks:
		if get_path(click["path"]) == "travel_result":
			delay = click["delay"]
			if delay > result_delay:
				result_delay = delay
	   if result_delay > -1:
               for path in set(click["path"] for click in record.clicks if click["delay"] <  result_delay):
	           	mapped_click = get_path(path) or "other"
		   	result[mapped_click] +=1
	       for click in record.clicks:
		   if click["delay"] <  result_delay:
		   	mapped_click = get_path(click["path"]) or "other"
		   	result[mapped_click + "_click"]+=1
    	yield Record(**result)

@cli.statinfra_job
def make_job(job, options, nirvana, statface_client):
    """Standart function according to Statistics conventions,
    see https://clubs.at.yandex-team.ru/statistics/1143"""

    report = ns.StatfaceReport() \
        .from_yaml_config(REPORT_YAML_CONFIG)\
        .path(REPORT_PATH)\
        .title(REPORT_TITLE.encode('utf8'))\
        .scale("daily")\
        .client(statface_client)

    dates = options.dates
    if len(dates) > 1:
        suffix = "{first}_{last}".format(first=dates[0], last=dates[-1])
    else:
        suffix = dates[0]

    job_root = nirvana.directories[0] if nirvana.directories else DEFAULT_DIR

    job = job.env(
	files=[LocalFile(os.path.join(directory, 'common.py'))],
        templates=dict(job_root=job_root,
	               suffix=suffix
                      )
    )

    input_table = nirvana.input_tables[0] if nirvana.input_tables else '$job_root/user_sessions/@dates'
    output_table = nirvana.output_tables[0] if nirvana.output_tables else '$job_root/travel_company_result/$suffix'

    job.table(input_table)\
	  .filter(nf.custom(is_one_org, "blocks"))\
	  .project("region",
		   "device",
                   "search_props",
		   "clicks",
		   "reqid",
		   "permalink",
                   fielddate=ne.custom(lambda x: x.split("T")[0], "time_isoformatted"))\
	  .project(ne.all(),
		rubric=ne.custom(norm_rubric, "main_rubric"),
		)\
          .map(clicks_filter)\
	  .map(add_totals_curried)\
	  .groupby("fielddate", *FIELDS)\
          .aggregate(click_count=na.count(),
                    request_count=na.count_distinct("reqid"),
                    dwelltime_median=na.median("dwelltime"),
                    result_delay_median=na.median("result_delay"))\
  	  .put(output_table)\
	  .publish(report)

    return job


if __name__ == "__main__":
    cli.run()
