# -*- coding: utf-8 -*-

from copy import copy
from itertools import combinations, chain
from nile.api.v1 import Record

DEFAULT_DIR = "home/travel/analytics"

TRAVEL_RUBRICS = {"184106414": u'Гостиница',
                  "184106404": u'Санаторий',
                  "184106400": u'Дом отдыха',
                  "20699506347": u'Хостел',
                  "184106426": u'Турбаза',
                  "1636761316": u'Жилье посуточно',
                  "184106420": u'Кемпинг',
		  "255921949": "Отдых на ферме",
		  "150049871970": u'Апартаменты'}

def add_totals(records, fields, special_cases):
    """The mapper should me curried before use"""
    for rec in records:
        proto_result = rec.to_dict()
        for n in range(len(fields) + 1):
             for combination in combinations(fields, n):
                 result = copy(proto_result)
                 for key, value in result.items():
                    if key in combination:
			if key in special_cases:
			    result[key] = special_cases[key]
			else:
                            result[key] = "total"
                 yield Record(**result)

def safe_int(val):
    try:
        return int(val)
    except (TypeError, ValueError):
        return 0

def safe_div(x, y):
    if x is None:
        x = 0
    if (not y) and (not x):
        return 0
    if (not y) and x:
	return 10000
    return x / float(y)


def norm_rubric(rubric_id):
    return int(rubric_id) if rubric_id in TRAVEL_RUBRICS else 1

class WizardType(object):
    OneOrg = '1Org'
    OrgMn = 'OrgMn'
    TravelOneOrgCompany = 'Travel1OrgCompany'
    TravelOneOrgRight = 'Travel1OrgRight'
    TravelOneOrg = 'Travel1Org'
    Carousel = 'Carousel'
    TravelOrgMn = 'TravelOrgMn' #на тачах
    Travel = 'HotelWizard' #deprecated
    OldTours = 'ToursWizard'
    EntitySearch = 'EntitySearch'

def get_hotel_wizards(blocks):
	return chain.from_iterable([blocks.get(wiz, []) for wiz in (WizardType.TravelOneOrgCompany, WizardType.TravelOneOrgRight, WizardType.TravelOneOrg)])

def is_one_org(blocks):
    return bool(blocks.get(WizardType.TravelOneOrg) or blocks.get(WizardType.TravelOneOrgRight) or blocks.get(WizardType.TravelOneOrgCompany))

WIZARDS = {
    '/snippet/companies/map': WizardType.OrgMn,
    '/snippet/companies/travel_map' : WizardType.TravelOrgMn,

    '/snippet/companies/company': WizardType.OneOrg,
    '/parallel/result/snippet/companies/company': WizardType.OneOrg,
    '/snippet/companies/travel_company': WizardType.TravelOneOrg,
    '/parallel/result/snippet/companies/travel_company': WizardType.TravelOneOrgRight,

    '/parallel/result/snippet/companies/map': WizardType.OrgMn,
    '/parallel/result/snippet/companies/travel_map': WizardType.TravelOrgMn,
    '/parallel/result/snippet/entity_search': WizardType.EntitySearch,
    '/parallel/result/wiz/companies/travel_map/upper': WizardType.Carousel,
}

BAD_TEST_IDS = {"89647", "88844", "92282", "90255", "93197", "93198", "93199", "93472", "93480", "93481", "93595"}


#-- path constructor --
CAROUSEL_PREFIX = "/parallel/result/wiz/companies/map/upper"
TRAVEL_BK_PREFIX = "/parallel/result/wiz/companies/travel_map/upper/tabs/list"
ORG_PREFIX = ("/parallel/result/snippet/companies/travel_company",
	"/snippet/companies/company",
	"/snippet/companies/travel_company",
	"/snippet/companies/travel_company/sideblock/org",
	"/snippet/companies/company/sideblock/hotels",
        "/snippet/companies/company/sideblock/org",
	"/snippet/companies/map/sideblock/hotels")

SIDEBLOCKS = ("/snippet/companies/company/sideblock",
	"/snippet/companies/travel_company/sideblock")

CAROUSEL_MAIN = "showcase"

search = {"date/at": "at",
		"date/to": "to",
		"person": "person",
		"submit": "submit"}

obj = {'object-badge/map': 'map',
       'object-badge/thumb': 'thumb',
       'object-badge/gallery': 'thumb',
       'object-badge/fullscreen/scroll': 'photo_scroll',
	'photo/fullscreen/scroll': 'photo_scroll',
       'reviews': 'reviews',
       'similar': 'similar',
       'site': 'site',
       'tabs': 'tabs',
	'address': 'address',
	'close': 'close',
	'phone': 'phone',
	'goto-map': 'goto_map',
	'drag': 'map_drag',
	'zoom': 'map_zoom',
        'viewer': 'photo_viewer',
	'popup/viewer': 'photo_viewer',
        'cut': 'feature_cut',
	'popup/close': "popup_close",
	'title': 'card_title',
	'hide': 'hide',
	'route': 'route',
	'table/rating': 'reviews'


	}

res =   {"result": "result",
        "feature-cut/content/result": "result",
	'result_by_partner': "mini_offer",
        "feature-cut/content/scroll": "result_scroll",
	"content/result": "result",
	"content/scroll": "result_scroll",
	"all_offers": "all_offers",
	}

ITEM = "item"
POPUP = "popup"
ELEMS = ("thumb", "topic")

other = {'/snippet/sitelinks': "link",
	    "/web/item/": "link",
	    "/head/logo": "new",
	    "/head/submit": "new",
	   "/head/username_menu/mail": "mail",
	   "/header/clear": "new",

	"/snippet/images/": "images",
	"/snippet/social_snippet": "social_snippet",
	"/snippet/video": "video",
	"/snippet/translate": "translate",
	"/snippet/bno/link": "link",
	"/snippet/realty": "realty",
	"/snippet/rabota": "rabota",
	"/snippet/entity_search": "entity_search",
	"/parallel/result/snippet/entity_search": "entity_search",

	"/serp/navig/images": "images",
        "/serp/navig/video": "video",
	"/serp/navig/market": "market",
	"/serp/navig/news": "news",
	 "/serp/navig/maps": "maps",

	"/pager": "pager",
	"/tabbar/maps": "maps",
	"/tabbar/video": "video",
	"/tabbar/images": "images",
	"/related": "related_query",
}


def gen_paths():
    SHORT_CAROUSEL_PREFIX = "/parallel/result/wiz/companies/travel_map/upper"
    for key, value in obj.items():
	yield ("/".join([SHORT_CAROUSEL_PREFIX, POPUP, key]), "_".join(["strange_popup", value]))
    yield ("/".join([SHORT_CAROUSEL_PREFIX, POPUP, "scroll"]), "strange_popup_scroll")
    for elem in ("map", "route"):
	for sideblock in SIDEBLOCKS:
		yield ("/".join([sideblock, elem]), "_".join(["travel", elem]))
    for key, value in other.items():
	yield (key, value)
    for prefix in (CAROUSEL_PREFIX, TRAVEL_BK_PREFIX):
        for key, value in obj.items():
                yield ("/".join([prefix, CAROUSEL_MAIN, ITEM, POPUP, key]), "_".join(["popup", value]))
        for key, value in search.items():
                yield ("/".join([prefix, key]), "_".join(["carousel", value]))
                yield ("/".join([prefix, CAROUSEL_MAIN, ITEM, POPUP, "form", key]), "_".join(["popup", value]))
	for key, value in res.items():
                yield ("/".join([prefix, CAROUSEL_MAIN, ITEM, POPUP, "form", key]), "_".join(["popup", value]))
        for elem in ELEMS:
                yield ("/".join([prefix, CAROUSEL_MAIN, ITEM, elem]), "carousel_item")
        yield ("/".join([prefix, CAROUSEL_MAIN, "scroll"]), "carousel_scroll")
    for prefix in ORG_PREFIX:
	option = "object-badge"
	for key, value in obj.items():
			yield ("/".join([prefix, option, key]), "_".join(["travel", value]))
	for key, value in search.items():
			yield ("/".join([prefix, option, "form", key]), "_".join(["travel", value]))
	for key, value in res.items():
			yield ("/".join([prefix, option, "form", key]), "_".join(["travel", value]))
	for key, value in res.items():
                        yield ("/".join([prefix, option, key]), "_".join(["travel", value]))


	#https://st.yandex-team.ru/EXPERIMENTS-24086: попап на декстопе
	for key, value in obj.items():
			yield ("/".join([prefix, option, POPUP, key]), "_".join(["travel", value]))
	for key, value in search.items():
			yield ("/".join([prefix, option, POPUP, "form", key]), "_".join(["travel", value]))
	for key, value in res.items():
			yield ("/".join([prefix, option, POPUP, "form", key]), "_".join(["travel", value]))

	#popup из "/snippet/companies/travel_company"
	for key, value in obj.items():
			yield ("/".join([prefix, POPUP, key]), "_".join(["travel", value]))
	for key, value in search.items():
			yield ("/".join([prefix, POPUP, "form", key]), "_".join(["travel", value]))
	for key, value in res.items():
			yield ("/".join([prefix, POPUP, "form", key]), "_".join(["travel", value]))



	for key, value in obj.items():
			yield ("/".join([prefix, key]), "_".join(["travel", value]))
	for key, value in search.items():
			yield ("/".join([prefix, "form", key]), "_".join(["travel", value]))
	for key, value in res.items():
			yield ("/".join([prefix, "form", key]), "_".join(["travel", value]))
	yield ("/".join([prefix, "form", "scroll"]), "_".join(["travel", "form_scroll"]))


paths = dict(gen_paths())

def get_path(path):
    if path == "": return "commercial"
    elif path.startswith("/parallel/result/wiz/companies/travel_map/upper/tabs/list/showcase/item/bcard/title"): return 'carousel_item_popup'
    elif path.startswith("/parallel/result/wiz/companies/travel_map/upper/tabs/list/showcase/item/bcard/price"): return 'carousel_item_price'
    elif path.startswith('/parallel/result/wiz/companies/travel_map/upper/tabs/map'): return 'carousel_map'
    elif path.startswith('/parallel/result/wiz/companies/travel_map/upper/promo'): return 'carousel_map_promo'
    elif path.startswith('/parallel/result/wiz/companies/travel_map/upper/tabs/list/switch'): return 'carousel_to_map_switch'
    elif path.startswith('/parallel/result/wiz/companies/travel_map/upper/tabs/list/showcase/item/bcard-map'): return 'carousel_map'
    elif path == "/snippet/companies/company/object-badge/show": return "tech"

    for key, value in paths.items():
    	if path.startswith(key):
		return value

