"""Builds extracts for factor learning, see HOTELS-2908"""
import os
import json
import urlparse
from copy import copy
import datetime as dt
from nile.api.v1 import Record, cli
from nile.files import LocalFile

directory = os.environ['JWD']
os.sys.path.append(directory)
from common import DEFAULT_DIR, BAD_TEST_IDS, TRAVEL_RUBRICS, norm_rubric,  WizardType, get_path

def process_full_request(url):
    """Parses cgi-parametrs dictionary from the full url"""
    cgi = list()
    for key, val in urlparse.parse_qs(urlparse.urlparse(url)[4]).iteritems():
        cgi.append((str(key), str(val[0])))
    return dict(cgi)


def get_ag_dynamic(full_request):
    cgi_dict = process_full_request(full_request)
    return json.loads(cgi_dict.get("ag_dynamic", "{}"))

def mapper(records):
    """Yields separate records for shows (separately for carousel and 1Org) and clicks"""
    FIELDS = ("region", "user_region", "reqid", "query", "uid", "device")
    for rec in records:
        proto_result = {key: value for key,
                        value in rec.to_dict().items() if key in FIELDS}
        proto_result["timestamp"] = str(rec.timestamp)
	proto_result["date"] = dt.datetime.fromtimestamp(rec.timestamp).date().isoformat()
        proto_result["rubrics"] = ""
        if "Carousel" in rec.blocks:
            result = copy(proto_result)
            result["event"] = "carousel_show"
            result["permalinks"] = rec.permalinks
            result["query"] = get_ag_dynamic(rec.full_request).get("text") or rec.query
            result["rubrics"] = rec.search_props.get("Rubrics", "")
            yield Record(**result)
        if "Travel1Org" in rec.blocks or ('HotelWizard' in rec.blocks and rec.device != "desktop"):
            result = copy(proto_result)
            result["event"] = "1Org_show"
	    permalink = rec.perlmalink
            result["permalinks"] = [permalink] if permalink else []
            yield Record(**result)
        for click in rec.clicks:
            path = click['path']
	    conv_path = get_path(path)
	    if conv_path == 'carousel_item':
                result = copy(proto_result)
                result["event"] = "carousel_click"
                permalink = [
                    int(get_ag_dynamic(click["url"]).get("middle_snippets_oid", 0))]
                result["permalinks"] = [permalink] if permalink else []
                result["timestamp"] = str(rec.timestamp + click["delay"])
                yield Record(**result)
	    elif conv_path in ("travel_submit", "travel_result"):
              	result = copy(proto_result)
                result["event"] = conv_path + "_click"
          	permalink = rec.permalink
                result["permalinks"] = [permalink] if permalink else []
                result["timestamp"] = str(rec.timestamp + click["delay"])
                yield Record(**result)


@cli.statinfra_job
def make_job(job, options, nirvana, statface_client):
    """Standart function according to Statistics conventions,
    see https://clubs.at.yandex-team.ru/statistics/1143"""

    dates = options.dates
    if len(dates) > 1:
        suffix = "{first}_{last}".format(first=dates[0], last=dates[-1])
    else:
        suffix = dates[0]

    job_root = nirvana.directories[0] if nirvana.directories else DEFAULT_DIR

    job = job.env(
        files=[LocalFile(os.path.join(directory, 'common.py'))],
        templates=dict(job_root=job_root,
                       suffix=suffix
                      )
    )

    input_table = nirvana.input_tables[0] if nirvana.input_tables else \
        '$job_root/user_sessions/@dates'
    output_table = nirvana.output_tables[0] if nirvana.output_tables else \
        '$job_root/session_factors/$suffix'

    job.table(input_table)\
       .map(mapper)\
       .put(output_table)

    return job


if __name__ == "__main__":
    cli.run()
