# -*- coding: utf-8 -*-


import os
from copy import copy
from functools import partial

from nile.api.v1 import (
    extractors as ne,
    aggregators as na,
    filters as nf,
    statface as ns,
    Record,
    cli
)

from nile.files import LocalFile

from qb2.api.v1 import (
    extractors as se,
    filters as sf,
    resources as sr
)

directory = os.environ['JWD']
os.sys.path.append(directory)
from common import DEFAULT_DIR, add_totals, norm_rubric, WizardType, get_path, is_one_org

REPORT_TITLE = u'Отельный 1Org на СЕРПе: последний внешний клик после поиска номеров'
REPORT_PATH = "Adhoc/Hotels/last_external_click_after_search"
REPORT_YAML_CONFIG = "last_external_click_after_search/after_search.yaml"

MAX_DELAY = 86400

FIELDS = ("device", "region", "rubric", "click_path")

add_totals_curried = partial(
    add_totals, fields=FIELDS, special_cases={"rubric": 0})

def clicks_filter(records):
    """Make flat table of clicks, only that happened before partner redirect"""
    for rec in records:
        proto_result = dict(device=rec.device,
		      region=rec.region,
                      rubric=rec.rubric,
		      fielddate=rec.fielddate,
		      reqid=rec.reqid)
        submit_delay = None
        for click in rec.clicks:
		if get_path(click["path"]) in ("travel_submit", "travel_offers"):
			delay = click["delay"]
			if delay > submit_delay:
				submit_delay = delay
        if submit_delay is not None:
	       results = []
               for click in rec.clicks:
	           if click["delay"] >  submit_delay and click["is_dynamic"] is False:
                       result = copy(proto_result)
                       result["delay"] = click["delay"] - submit_delay
 		       result["dwelltime"] = min(MAX_DELAY, click["dwelltime"])
		       result["click_path"] = get_path(click["path"]) or "other"
                       results.append(result)
	       if results:
	           results = sorted(results, key=lambda x: x["delay"], reverse=True)
		   result= results[0]
     		   yield Record(**result)

@cli.statinfra_job
def make_job(job, options, nirvana, statface_client):

    report = ns.StatfaceReport() \
        .from_yaml_config(REPORT_YAML_CONFIG)\
        .path(REPORT_PATH)\
        .title(REPORT_TITLE.encode('utf8'))\
        .scale("daily")\
        .client(statface_client)

    dates = options.dates
    if len(dates) > 1:
        suffix = "{first}_{last}".format(first=dates[0], last=dates[-1])
    else:
        suffix = dates[0]

    job_root = nirvana.directories[0] if nirvana.directories else DEFAULT_DIR

    job = job.env(
	files=[LocalFile(os.path.join(directory, 'common.py'))],
        templates=dict(job_root=job_root,
	               suffix=suffix
                      )
    )

    input_table = nirvana.input_tables[0] if nirvana.input_tables else '$job_root/user_sessions/@dates'
    output_table = nirvana.output_tables[0] if nirvana.output_tables else '$job_root/last_external_after_search/$suffix'

    job.table(input_table)\
	  .filter(nf.custom(is_one_org, "blocks"))\
	  .project("region",
		   "device",
		   "clicks",
                   "reqid",
	           "main_rubric",
		   fielddate=ne.custom(lambda x: x.split("T")[0], "time_isoformatted"),
		   )\
	  .project(ne.all(),
		rubric=ne.custom(norm_rubric, "main_rubric"),
		)\
          .map(clicks_filter)\
	  .map(add_totals_curried)\
	  .groupby("fielddate", *FIELDS)\
          .aggregate(click_count=na.count(),
                    request_count=na.count_distinct("reqid"),
                    dwelltime_median=na.median("dwelltime"),
                    delay_median=na.median("delay"))\
  	  .put(output_table)\
	  .publish(report)

    return job


if __name__ == "__main__":
    cli.run()
