# -*- coding: utf-8 -*-

import os
# from copy import copy
# from itertools import combinations
from functools import partial

from nile.api.v1 import (
    extractors as ne,
    aggregators as na,
    filters as nf,
    statface as ns,
    Record,
    cli
)

from nile.files import LocalFile

from qb2.api.v1 import (
    extractors as se,
    filters as sf,
    resources as sr
)


directory = os.environ['JWD']
os.sys.path.append(directory)
from common import BAD_TEST_IDS, DEFAULT_DIR, TRAVEL_RUBRICS, add_totals, norm_rubric, WizardType, is_one_org

REPORT_TITLE = u'Отельный ответ на СЕРПе (главное)'
REPORT_PATH = "Adhoc/Hotels/Serp-Main"
REPORT_YAML_CONFIG = "main_serp_metrics/serp_hotels.yaml"

FIELDS = ("device", "region", "rubric", "request_after_carousel_click", "mn_org_type", "num_of_hotel_urls", "entity_search")

add_totals_curried = partial(
    add_totals, fields=FIELDS, special_cases={"rubric": 0})

def get_type(blocks):
    bk = any(elem["path"].startswith("/tabs/list") for elem in blocks.get(WizardType.Carousel, []))
    carousel =  bool(blocks.get(WizardType.Carousel)) and not bk
    org_mn = bool(blocks.get(WizardType.OrgMn))
    if carousel + org_mn + bk== 0:
	return None
    elif carousel and org_mn:
	return "carousel_org_mn"
    elif bk and org_mn:
	return "bk_org_mn"
    elif carousel and not bk:
	return "carousel"
    elif bk:
	return "bk"
    return "org_mn"


@cli.statinfra_job
def make_job(job, options, nirvana, statface_client):
    """Standart function according to Statistics conventions,
    see https://clubs.at.yandex-team.ru/statistics/1143"""

    report = ns.StatfaceReport() \
        .from_yaml_config(REPORT_YAML_CONFIG)\
        .path(REPORT_PATH)\
        .title(REPORT_TITLE.encode('utf8'))\
        .scale("daily")\
        .client(statface_client)

    dates = options.dates
    if len(dates) > 1:
        suffix = "{first}_{last}".format(first=dates[0], last=dates[-1])
    else:
        suffix = dates[0]

    job_root = nirvana.directories[0] if nirvana.directories else DEFAULT_DIR

    job = job.env(
	files=[LocalFile(os.path.join(directory, 'common.py'))],
        templates=dict(job_root=job_root,
                       suffix=suffix,
                       )
                 )

    input_table = nirvana.input_tables[0] if nirvana.input_tables else \
       '$job_root/user_sessions/@dates'
    output_table = nirvana.output_tables[0] if nirvana.output_tables else \
        '$job_root/carousel_main_serp_metrics/$suffix'

    job.table(input_table)\
	.filter(nf.custom(lambda test_ids: not BAD_TEST_IDS.intersection(test_ids), "test_ids"))\
        .project("region",
                 "device",
                 "search_props",
                 num_of_hotel_urls=ne.custom(lambda x: str(len(x)), "hotel_urls"),
		 mn_org_type=ne.custom(get_type, "blocks"),
                 request_after_carousel_click=ne.const("before"),
                 entity_search=ne.custom(lambda x: "yes" if x.get(
                     WizardType.EntitySearch) is not None else "no", "blocks"),
                 travel_1org=ne.custom(is_one_org, "blocks"),
                 carousel=ne.custom(lambda blocks, test_ids: blocks.get(
                     WizardType.Carousel) is not None and not BAD_TEST_IDS.intersection(test_ids), "blocks", "test_ids"),
                 travel_1org_carousel=ne.custom(lambda x: (x.get(WizardType.Carousel) is not None) and (
                     x.get(WizardType.TravelOneOrg) is not None), "blocks"),
                 vanilla_1org_carousel=ne.custom(lambda x: (x.get(WizardType.Carousel) is not None) and (
                     x.get(WizardType.OneOrg) is not None), "blocks"),
                 empty_clicked_carousel=ne.const(False),
                 fielddate=ne.custom(lambda x: x.split("T")[0], "time_isoformatted"))\
	.filter(nf.or_(sf.defined("mn_org_type"),
		       sf.defined("travel_1org")))\
        .project(ne.all(),
                 rubric=ne.custom(lambda search_props, carousel: search_props.get("Rubrics") if carousel else search_props.get("FirstRubricId"), "search_props", "carousel"))\
        .project(ne.all(),
 		 mn_org_type=ne.custom(lambda x: x or "None", "mn_org_type"),
                 rubric=ne.custom(norm_rubric, "rubric"))\
        .map(add_totals_curried)\
        .groupby("fielddate", *FIELDS)\
        .aggregate(travel_1org=na.count(predicate=nf.equals("travel_1org", True)),
                   carousel=na.count(predicate=nf.equals("carousel", True)),
                   vanilla_1org_carousel=na.count(
            predicate=nf.equals("vanilla_1org_carousel", True)),
        travel_1org_carousel=na.count(
            predicate=nf.equals("travel_1org_carousel", True)),
        empty_clicked_carousel=na.count(predicate=nf.equals("empty_clicked_carousel", True)))\
        .put(output_table)\
        .publish(report)

    return job


if __name__ == "__main__":
    cli.run()
