# -*- coding: utf-8 -*-

import os
from copy import copy
from functools import partial

from nile.api.v1 import (
    extractors as ne,
    aggregators as na,
    filters as nf,
    statface as ns,
    Record,
    cli
)

from nile.files import LocalFile

from qb2.api.v1 import (
    extractors as se,
    filters as sf,
    resources as sr
)

directory = os.environ['JWD']
os.sys.path.append(directory)
from common import DEFAULT_DIR, BAD_TEST_IDS, TRAVEL_RUBRICS, add_totals, norm_rubric, safe_int, WizardType, get_path


REPORT_TITLE = u'Количество запросов на uid на СЕРПе (без пассивных uid)'
REPORT_PATH = "Adhoc/Hotels/Reqids_per_uid_non_null_1"
REPORT_YAML_CONFIG = "queries_per_uid/queries_per_uid.yaml"

FIELDS = ("device", "region", "logged_in")

add_totals_curried = partial(
    add_totals, fields=FIELDS, special_cases=dict())


@cli.statinfra_job
def make_job(job, options, nirvana, statface_client):
    """Standart function according to Statistics conventions,
    see https://clubs.at.yandex-team.ru/statistics/1143"""

    report = ns.StatfaceReport() \
        .from_yaml_config(REPORT_YAML_CONFIG)\
        .path(REPORT_PATH)\
        .title(REPORT_TITLE.encode('utf8'))\
        .scale("daily")\
        .client(statface_client)

    dates = options.dates
    if len(dates) > 1:
        suffix = "{first}_{last}".format(first=dates[0], last=dates[-1])
    else:
        suffix = dates[0]

    job_root = nirvana.directories[0] if nirvana.directories else DEFAULT_DIR

    job = job.env(
	files=[LocalFile(os.path.join(directory, 'common.py'))],
        templates=dict(job_root=job_root,
                       suffix=suffix
                       )
    )

    input_table = nirvana.input_tables[0] if nirvana.input_tables else \
       '$job_root/user_sessions/@dates'
    output_table = nirvana.output_tables[0] if nirvana.output_tables else \
        '$job_root/queries_per_uid/$suffix'

    job.table(input_table)\
        .project("region",
                 "device",
		 "uid",
                 "query",
                 logged_in=ne.custom(lambda x: "yes" if x else "no", "passport_uid"),
                 travel_1org=ne.custom(lambda x: x.get(
                     WizardType.TravelOneOrg) is not None, "blocks"),
                 carousel=ne.custom(lambda blocks, test_ids: (blocks.get(
                     WizardType.Carousel) is not None) and (not BAD_TEST_IDS.intersection(test_ids), "blocks", "test_ids") and (blocks.get(
                     WizardType.TravelOneOrg) is None)) ,
                 fielddate=ne.custom(lambda x: x.split("T")[0], "time_isoformatted"))\
        .map(add_totals_curried)\
        .groupby("fielddate", "query", "uid", *FIELDS)\
        .aggregate(travel_1org=na.count(predicate=nf.equals("travel_1org", True)),
                   carousel=na.count(predicate=nf.equals("carousel", True)),
		   )\
	 .groupby("fielddate", *FIELDS)\
	 .aggregate(travel_1org=na.mean("travel_1org", predicate=nf.custom(lambda x: x>0, "travel_1org")),
                    carousel=na.mean("carousel", predicate=nf.custom(lambda x: x>0, "carousel")))\
        .put(output_table)\
        .publish(report)

    return job


if __name__ == "__main__":
    cli.run()
