# -*- coding: utf-8 -*-

from itertools import combinations
from copy import copy
from nile.api.v1 import Record

TRAVEL_RUBRICS = {"184106414": u'Гостиница',
                  "184106404": u'Санаторий',
                  "184106400": u'Дом отдыха',
                  "20699506347": u'Хостел',
                  "184106426": u'Турбаза',
                  "1636761316": u'Жилье посуточно',
                  "184106420": u'Кемпинг',
		 "150049871970": u'Апартаменты'}

class WizardType(object):
    OneOrg = '1Org'
    OrgMn = 'OrgMn'
    TravelOneOrg = 'Travel1Org'
    Carousel = 'Carousel'
    OldTravel = 'HotelWizard'
    OldTours = 'ToursWizard'
    EntitySearch = 'EntitySearch'
    BK = "BK"


def safe_int(val):
    try:
        return int(val)
    except (TypeError, ValueError):
        return 0

def norm_rubric(rubric_id):
    return safe_int(rubric_id) if rubric_id in TRAVEL_RUBRICS else 1

def add_totals(records, fields, special_cases):
    """The mapper should me curried before use"""
    for rec in records:
        proto_result = rec.to_dict()
        for n in range(len(fields) + 1):
             for combination in combinations(fields, n):
                 result = copy(proto_result)
                 for key, value in result.items():
                    if key in combination:
			if key in special_cases:
			    result[key] = special_cases[key]
			else:
                            result[key] = "total"
                 yield Record(**result)

DEFAULT_DIR = "home/travel/analytics"
