# encoding: utf-8

from collections import defaultdict
import logging
import gevent


class HttpError(object):
    def __init__(self):
        self.txt = ''
        self.cnt = 0

    def __repr__(self):
        return "%s times, last: '%s'" % (self.cnt, self.txt)


class Stat(object):
    def __init__(self):
        self.ok_cnt = 0
        self.http_error_cnt = 0
        self.http_errors = defaultdict(HttpError)  # HttpError -> count
        self.no_free_session_cnt = 0

    def on_ok(self):
        self.ok_cnt += 1

    def on_http_error(self, code, text):
        self.http_error_cnt += 1
        f = self.http_errors[code]
        f.cnt += 1
        f.txt = text

    def on_no_free_session(self):
        self.no_free_session_cnt += 1


class StatOwner(object):
    def __init__(self):
        self.stat = Stat()
        self.printer = gevent.spawn(self.print_loop)

    def print_loop(self):
        while True:
            gevent.sleep(10)
            stat = self.stat
            self.stat = Stat()
            http_errors = [(k, v) for k, v in stat.http_errors.items()]
            http_errors = sorted(http_errors, key=lambda p: p[1].cnt, reverse=True)
            logging.info("OK: %s, NoFreeSession: %s, Failed: %s, causes: %s" % (
                stat.ok_cnt, stat.no_free_session_cnt, stat.http_error_cnt, http_errors))
