# encoding: utf-8

import gevent
import logging

from ticket_parser2.api.v1 import TvmClient, TvmClientStatus, TvmApiClientSettings


class Tvm(object):
    def __init__(self, service_id, client_id, client_secret):
        self.ticket = None
        self.client = None
        if not client_secret:
            return
        destinations = {'api': service_id}
        settings = TvmApiClientSettings(
            self_client_id=client_id,
            enable_service_ticket_checking=True,
            enable_user_ticket_checking=False,
            self_secret=client_secret,
            dsts=destinations,
        )
        self.client = TvmClient(settings)
        if self.client.status != TvmClientStatus.Ok:
            raise Exception("tvm client has bad status: " + TvmClient.status_to_string(self.client.status))
        self.update_ticket()
        gevent.spawn(self.loop)

    def update_ticket(self):
        try:
            self.ticket = self.client.get_service_ticket_for('api')
            logging.info("Got new TVM ticket")
        except:
            logging.exception('Failed to get ticket')

    def loop(self):
        while True:
            gevent.sleep(600)
            self.update_ticket()

    def get_ticket(self):
        return self.ticket
