import sys
from argparse import ArgumentParser

from travel.hotels.tools.boy_catroom_builder.dolphin import DolphinCatroomBuilder
from travel.hotels.tools.boy_catroom_builder.expedia import ExpediaCatroomBuilder
from travel.hotels.tools.boy_catroom_builder.travelline import TravellineCatroomBuilder


PARTNERS = {
    'dolphin': DolphinCatroomBuilder,
    'expedia': ExpediaCatroomBuilder,
    'travelline': TravellineCatroomBuilder,
}


def main(args):
    parser = ArgumentParser()
    parser.add_argument('--partner', type=str, required=True, help='Partner name', choices=PARTNERS.keys())

    parsed_args, rest = parser.parse_known_args(args)

    PARTNERS[parsed_args.partner].main(rest)


if __name__ == '__main__':
    main(sys.argv[1:])
