# coding=utf-8
from __future__ import print_function
from datetime import date, timedelta, datetime

import logging

from catroom_builder import CommonCatroomBuilder
from offsets import DOLPHIN_PERMAROOM_ID_OFFSET

LOG = logging.getLogger(__name__)

DATE_FORMAT = '%Y-%m-%d'


class DolphinCatroomBuilder(CommonCatroomBuilder):
    name = 'dolphin'
    operator_id = 'OI_DOLPHIN'

    PERMAROOM_ID_OFFSET = CommonCatroomBuilder.PERMAROOM_ID_OFFSET + DOLPHIN_PERMAROOM_ID_OFFSET

    def __init__(self, session, args):
        super(DolphinCatroomBuilder, self).__init__(session, args)

        self.days = args.days
        self.date = args.date

    @staticmethod
    def configure_arg_parser(parser, proc_env):
        common_group = parser.add_argument_group(DolphinCatroomBuilder.name)
        common_group.add_argument(
            "--date",
            type=lambda x: datetime.strptime(x, DATE_FORMAT).date(),
            default=date.today(),
        )
        common_group.add_argument(
            "--days",
            type=int,
            default=31,
        )

    def extract_rooms(self):
        from_date = (self.date - timedelta(days=self.days)).strftime(DATE_FORMAT)
        to_date = self.date.strftime(DATE_FORMAT)

        self.extract_rooms_from_search_result_log(from_date, to_date)
