# coding=utf-8
from __future__ import print_function
import logging

from yt.wrapper import YPath

from catroom_builder import CommonCatroomBuilder, FEED_TABLES
from offsets import EXPEDIA_PERMAROOM_ID_OFFSET

LOG = logging.getLogger(__name__)


class ExpediaCatroomBuilder(CommonCatroomBuilder):
    name = 'expedia'
    operator_id = 'OI_EXPEDIA'

    PERMAROOM_ID_OFFSET = CommonCatroomBuilder.PERMAROOM_ID_OFFSET + EXPEDIA_PERMAROOM_ID_OFFSET

    def __init__(self, session, args):
        super(ExpediaCatroomBuilder, self).__init__(session, args)
        self.feed_directory = YPath(args.feed_directory)

    @staticmethod
    def configure_arg_parser(parser, proc_env):
        common_group = parser.add_argument_group(ExpediaCatroomBuilder.name)
        common_group.add_argument(
            "--feed-directory",
            default='//home/travel/prod/feeds/expedia/latest/parsed'
        )

    def extract_rooms(self):
        self.extract_rooms_from_feed([self.feed_directory.join(table) for table in FEED_TABLES])
