# coding=utf-8
from __future__ import print_function
import logging

from yt.wrapper import YPath

from catroom_builder import CommonCatroomBuilder, FEED_TABLES
from offsets import TRAVELLINE_PERMAROOM_ID_OFFSET

LOG = logging.getLogger(__name__)


class TravellineCatroomBuilder(CommonCatroomBuilder):
    name = 'travelline'
    operator_id = 'OI_TRAVELLINE'

    PERMAROOM_ID_OFFSET = CommonCatroomBuilder.PERMAROOM_ID_OFFSET + TRAVELLINE_PERMAROOM_ID_OFFSET

    def __init__(self, session, args):
        super(TravellineCatroomBuilder, self).__init__(session, args)
        self.feed_directory = YPath(args.feed_directory)

    @staticmethod
    def configure_arg_parser(parser, proc_env):
        common_group = parser.add_argument_group(TravellineCatroomBuilder.name)
        common_group.add_argument(
            "--feed-directory",
            default='//home/travel/prod/feeds/travelline/latest/parsed'
        )

    def extract_rooms(self):
        self.extract_rooms_from_feed([self.feed_directory.join(table) for table in FEED_TABLES])
