package main

import (
	"a.yandex-team.ru/travel/hotels/tools/boy_hotels_checker/internal/core"
	"a.yandex-team.ru/travel/hotels/tools/boy_hotels_checker/pkg/cfg"
	"context"
	"log"
	"time"
)

func main() {
	settings := core.GetConfigSettings()
	settings = append(settings, &botToken, &cfg.YavToken, &ytToken, &ytProxy, &ytPath, &cacheDir)

	if err := cfg.LoadSettings(settings...); err != nil {
		log.Fatal(err)
	}

	configuration := core.HotelCacheConfiguration{
		CacheFileName: cacheDir.Value + "/hotels.gob",
		SaveChanges:   true,
		YtProxy:       ytProxy.Value,
		YtToken:       ytToken.Value,
		CacheYtPath:   ytPath.Value + "/hotel_cache",
	}

	cache := core.NewHotelCache(context.Background(), configuration)
	bot := NewBot(&cache)
	cache.ScheduleUpdates(time.Minute, context.Background())
	cache.Update(context.Background())
	bot.StartListening()
}
