package main

import (
	"a.yandex-team.ru/travel/hotels/tools/boy_hotels_checker/internal/core"
	tb "gopkg.in/tucnak/telebot.v2"
	"log"
	"regexp"
	"strings"
	"time"
)

const dateLayout = "2006-01-02"

var headerExpr = regexp.MustCompile(`Отель\s(?P<Hotel>\d+)\s\((?P<Partner>\w+)\).*`)

func parseDates(input string) (checkin time.Time, checkout time.Time) {
	parts := strings.Split(input, " ")
	switch len(parts) {
	case 1:
		parsed, err := time.Parse(dateLayout, input)
		if err != nil {
			return time.Time{}, time.Time{}
		}
		checkin = parsed
		checkout = checkin.AddDate(0, 0, 1)
		return
	case 2:
		checkinParsed, err := time.Parse(dateLayout, parts[0])
		if err != nil {
			return time.Time{}, time.Time{}
		}
		checkoutParsed, err := time.Parse(dateLayout, parts[1])
		if err != nil {
			return time.Time{}, time.Time{}
		}
		return checkinParsed, checkoutParsed
	}
	return time.Time{}, time.Time{}
}

func parseID(id string) (string, core.Partner) {
	parts := strings.Split(id, ":")
	var prefix string
	var hotelID string
	if len(parts) > 1 {
		prefix = parts[0]
		hotelID = strings.Join(parts[1:], ":")
	} else {
		hotelID = id
	}
	partner, found := prefixToPartner[prefix]
	if !found {
		return "", core.UnknownPartner
	}
	return hotelID, partner
}

func parseHotelDataFromMessageTest(text string) (hotelID string, partner core.Partner) {
	parts := headerExpr.FindStringSubmatch(text)
	if len(parts) != 3 {
		return "", core.UnknownPartner
	}
	hotelID = parts[1]
	partner = core.Partner(parts[2])
	return
}

func logMessage(message *tb.Message) {
	log.Printf("[%s]: %s", message.Sender.Username, message.Text)
}

func logCallback(callback *tb.Callback, action string) {
	log.Printf("[%s] activated %s", callback.Sender.Username, action)
}
