package main

import (
	"a.yandex-team.ru/travel/hotels/tools/boy_hotels_checker/pkg/cfg"
)

var yqlToken = cfg.ConfigurableSetting{
	Name:        "yql-token",
	Description: "YQL token",
	SecretID:    "sec-01d8t7zednvzpayps7k0pf12vb",
	SecretName:  "yql-oauth-key",
	LoadFromEnv: true,
	EnvVarName:  "YQL_TOKEN",
	Required:    true,
	IsSecret:    true,
}

var ytToken = cfg.ConfigurableSetting{
	Name:        "yt-token",
	Description: "YT token",
	SecretID:    "sec-01d8t7zednvzpayps7k0pf12vb",
	SecretName:  "yt-oauth-key",
	LoadFromEnv: true,
	EnvVarName:  "YT_TOKEN",
	Required:    true,
	IsSecret:    true,
}

var ytProxy = cfg.ConfigurableSetting{
	Name:        "yt-proxy",
	Value:       "hahn",
	Description: "YT proxy",
	LoadFromEnv: true,
	EnvVarName:  "YT_PROXY",
	Required:    true,
}

var ytPath = cfg.ConfigurableSetting{
	Name:        "yt-path",
	Value:       "//home/travel/testing/boy-hotel-checker",
	Description: "path to YT-directory to store check results",
	LoadFromEnv: false,
	Required:    true,
}

var sleepTime = cfg.ConfigurableSetting{
	Name:        "sleep-time",
	Value:       "100",
	Description: "Time to sleep between hotel checks (ms)",
	LoadFromEnv: false,
	Required:    true,
}

var loadLimit = cfg.ConfigurableSetting{
	Name:        "limit",
	Description: "limit the amount of loaded hotels",
	LoadFromEnv: false,
	Required:    false,
}
