package main

import (
	"a.yandex-team.ru/travel/hotels/tools/boy_hotels_checker/internal/core"
	"a.yandex-team.ru/travel/hotels/tools/boy_hotels_checker/pkg/cfg"
	"context"
	"log"
	"strconv"
	"time"
)

func main() {
	settings := core.GetConfigSettings()
	settings = append(settings, &ytProxy, &ytToken, &ytPath, &sleepTime, &loadLimit, &yqlToken, &cfg.YavToken)

	if err := cfg.LoadSettings(settings...); err != nil {
		log.Fatal(err)
	}

	cache := core.NewHotelCache(context.Background(),
		core.HotelCacheConfiguration{})
	cache.Update(context.Background())

	limit := 0
	if loadLimit.Value != "" {
		var err error
		limit, err = strconv.Atoi(loadLimit.Value)
		if err != nil {
			log.Fatal(err)
		}
	}

	sleepTimeMsInt, err := strconv.Atoi(sleepTime.Value)
	if err != nil {
		log.Fatal(err)
	}

	err = run(context.Background(), &cache, limit, ytPath.Value+"/results", time.Duration(sleepTimeMsInt)*time.Millisecond)
	if err != nil {
		log.Fatal(err)
	}
}
