package core

import (
	"a.yandex-team.ru/travel/hotels/tools/boy_hotels_checker/pkg/cfg"
)

func GetConfigSettings() []*cfg.ConfigurableSetting {
	return []*cfg.ConfigurableSetting{
		&offerCacheURL,
		&geoSearchAPI,
		&oauthAPI,
		&extAPI,
		&travellineAPI,
		&bnovoPrivateAPI,
		&bnovoPublicAPI,
		&tlOauthClientID,
		&tlOauthClientSecret,
		&bnOauthClientID,
		&bnOauthClientSecret,
		&tlAvailabilityAPIKey,
		&tlConnectionAPIKey,
		&bnovoUsername,
		&bnovoPassword,
	}
}

var offerCacheURL = cfg.ConfigurableSetting{
	Name:        "offer-cache",
	Description: "Endpoint of OfferCache API",
	Value:       "http://travel-hotels-offercache.yandex.net:11001",
	Required:    true,
}

var geoSearchAPI = cfg.ConfigurableSetting{
	Name:        "geo-search",
	Description: "Endpoint of GeoSearch API",
	Value:       "http://addrs-testing.search.yandex.net/search/stable/yandsearch",
	Required:    true,
}

var oauthAPI = cfg.ConfigurableSetting{
	Name:        "oauth",
	Description: "Endpoint of Yandex OAuth API",
	Value:       "https://oauth.yandex.ru/token",
	Required:    true,
}

var extAPI = cfg.ConfigurableSetting{
	Name:        "ext-api",
	Description: "Endpoint of External API",
	Value:       "https://hotels-api-ext.travel.yandex.net",
	Required:    true,
}

var travellineAPI = cfg.ConfigurableSetting{
	Name:        "travelline-api",
	Description: "Endpoint of the Travelline API",
	Value:       "https://yandex.tlintegration.com",
	Required:    true,
}

var bnovoPrivateAPI = cfg.ConfigurableSetting{
	Name:        "bnovo-private-api",
	Description: "Endpoint of the private BNovo API",
	Value:       "https://api.reservationsteps.ru/v1/api",
	Required:    true,
}

var bnovoPublicAPI = cfg.ConfigurableSetting{
	Name:        "bnovo-public-api",
	Description: "Endpoint of the public BNovo API",
	Value:       "https://public-api.reservationsteps.ru/v1/api",
	Required:    true,
}

var tlOauthClientID = cfg.ConfigurableSetting{
	Name:        "tl-oauth-client-id",
	Description: "Client id to authorize in oauth for travelline external api",
	SecretID:    "sec-01e492g9q6bhdkkvqz8fq3y1j7",
	SecretName:  "travelline_client_id",
	LoadFromEnv: true,
	Required:    true,
	IsSecret:    true,
}
var tlOauthClientSecret = cfg.ConfigurableSetting{
	Name:        "tl-oauth-client-secret",
	Description: "Client secret to authorize in oauth for travelline external api",
	SecretID:    "sec-01e492g9q6bhdkkvqz8fq3y1j7",
	SecretName:  "travelline_client_secret",
	LoadFromEnv: true,
	Required:    true,
	IsSecret:    true,
}
var bnOauthClientID = cfg.ConfigurableSetting{
	Name:        "bn-oauth-client-id",
	Description: "Client id to authorize in oauth for bnovo external api",
	SecretID:    "sec-01e492g9q6bhdkkvqz8fq3y1j7",
	SecretName:  "bnovo_client_id",
	LoadFromEnv: true,
	Required:    true,
	IsSecret:    true,
}
var bnOauthClientSecret = cfg.ConfigurableSetting{
	Name:        "bn-oauth-client-secret",
	Description: "Client secret to authorize in oauth for bnovo external api",
	SecretID:    "sec-01e492g9q6bhdkkvqz8fq3y1j7",
	SecretName:  "bnovo_client_secret",
	LoadFromEnv: true,
	Required:    true,
	IsSecret:    true,
}
var tlAvailabilityAPIKey = cfg.ConfigurableSetting{
	Name:        "travelline-availability-api-key",
	Description: "Travelline's API key to authorize in their availability API to check for offers",
	SecretID:    "sec-01ddqrmtm6vyehw2n4wz3qan16",
	SecretName:  "travelline-api-key",
	LoadFromEnv: true,
	Required:    true,
	IsSecret:    true,
}
var tlConnectionAPIKey = cfg.ConfigurableSetting{
	Name:        "travelline-connection-api-key",
	Description: "Travelline's API key to authorize in their offer API to check for hotel connection",
	SecretID:    "sec-01ddqrmtm6vyehw2n4wz3qan16",
	SecretName:  "travelline-test-api-key",
	LoadFromEnv: true,
	Required:    true,
	IsSecret:    true,
}
var bnovoUsername = cfg.ConfigurableSetting{
	Name:        "bnovo-username",
	Description: "Username to authorize in private bnovo api to check for hotel connection",
	Value:       "travel-hotels-partners@yandex-team.ru",
	LoadFromEnv: true,
	Required:    true,
}

var bnovoPassword = cfg.ConfigurableSetting{
	Name:        "bnovo-password",
	Description: "Password to authorize in private bnovo api to check for hotel connection",
	SecretID:    "sec-01ddqrmtm6vyehw2n4wz3qan16",
	SecretName:  "bnovo-new-password",
	LoadFromEnv: true,
	Required:    true,
	IsSecret:    true,
}
