package core

import (
	"a.yandex-team.ru/travel/hotels/tools/boy_hotels_checker/pkg/utils"
	"context"
	"errors"
	"fmt"
	"net/http"
	"net/url"
)

func checkPublishingStatusImpl(partner *partnerSetting, hotelID string) (bool, error) {
	var clientID, clientSecret, suffix, hotelIDParamName string
	switch partner.Name {
	case Travelline:
		clientID = tlOauthClientID.Value
		clientSecret = tlOauthClientSecret.Value
		suffix = "travelline"
		hotelIDParamName = "hotel.code"
	case BNovo:
		clientID = bnOauthClientID.Value
		clientSecret = bnOauthClientSecret.Value
		suffix = "bnovo"
		hotelIDParamName = "hotel_code"
	default:
		return false, errors.New("unsupported partner")
	}
	extAPIUrl := fmt.Sprintf("%s/%s/hotel_status", extAPI.Value, suffix)
	token, err := getOauthToken(clientID, clientSecret)
	if err != nil {
		return false, err
	}
	q := url.Values{}
	q.Add(hotelIDParamName, hotelID)
	h := http.Header{}
	h.Add("Authorization", "Bearer "+token)
	parsed, err := utils.HTTPGet(extAPIUrl, q, h)
	if err != nil {
		httpErr, matches := err.(utils.UnexpectedHTTPStatusError)
		if matches && httpErr.StatusCode == 404 {
			return false, nil
		}
		return false, err
	}
	if parsed.Exists("hotel_status", "status") {
		status := string(parsed.GetStringBytes("hotel_status", "status"))
		return status == "published", nil
	} else {
		return false, nil
	}
}

func checkAgreementStatus(partner Partner, inn string) (bool, error) {
	var clientID, clientSecret, suffix string
	switch partner {
	case BNovo:
		clientID = bnOauthClientID.Value
		clientSecret = bnOauthClientSecret.Value
		suffix = "bnovo"
	default:
		return false, errors.New("unsupported partner")
	}
	extAPIUrl := fmt.Sprintf("%s/%s/check_agreement", extAPI.Value, suffix)
	token, err := getOauthToken(clientID, clientSecret)
	if err != nil {
		return false, err
	}
	q := url.Values{}
	q.Add("inn", inn)
	h := http.Header{}
	h.Add("Authorization", "Bearer "+token)
	parsed, err := utils.HTTPGet(extAPIUrl, q, h)
	if err != nil {
		return false, err
	}
	if parsed.Exists("agreement") {
		return string(parsed.GetStringBytes("agreement")) == "found", nil
	}
	return false, nil
}

func checkPublishingStatus(ctx context.Context, partner *partnerSetting, hotelID string) chan boolWithError {
	resultChannel := make(chan boolWithError)
	go func() {
		defer close(resultChannel)
		res, err := checkPublishingStatusImpl(partner, hotelID)
		select {
		case resultChannel <- boolWithError{res, err}:
		case <-ctx.Done():
		}
	}()
	return resultChannel
}
