package core

import (
	"context"
	"fmt"
	"github.com/valyala/fastjson"
	"io/ioutil"
	"net/http"
)

type geoCheckResult struct {
	Permalink string
	Name      string
	URL       string
	err       error
}

func checkHotelStatusInGeoImpl(partner *partnerSetting, hotelID string) geoCheckResult {
	request, err := http.NewRequest("GET", geoSearchAPI.Value, nil)
	if err != nil {
		return geoCheckResult{
			err: err,
		}
	}
	q := request.URL.Query()
	q.Add("lang", "ru_RU")
	q.Add("origin", "test")
	q.Add("ms", "json")
	q.Add("mode", "oid")
	q.Add("type", "biz")
	q.Add("business_reference", fmt.Sprintf("%s:%s", partner.AltaySlug, hotelID))
	q.Add("business_show_closed", "1")
	request.URL.RawQuery = q.Encode()
	resp, err := http.DefaultClient.Do(request)
	if err != nil {
		return geoCheckResult{
			err: err,
		}
	}
	result, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return geoCheckResult{
			err: err,
		}
	}
	parsed, err := fastjson.ParseBytes(result)
	if err != nil {
		return geoCheckResult{
			err: err,
		}
	}
	res := geoCheckResult{}
	if parsed.Exists("features", "0", "properties", "CompanyMetaData", "id") {
		permalink := string(parsed.GetStringBytes("features", "0", "properties", "CompanyMetaData", "id"))
		res.Permalink = permalink
	}
	if parsed.Exists("features", "0", "properties", "CompanyMetaData", "name") {
		name := string(parsed.GetStringBytes("features", "0", "properties", "CompanyMetaData", "name"))
		res.Name = name
	}
	if parsed.Exists("features", "0", "properties", "CompanyMetaData", "url") {
		res.URL = string(parsed.GetStringBytes("features", "0", "properties", "CompanyMetaData", "url"))
	}
	return res
}

func checkHotelStatusInGeo(ctx context.Context, partner *partnerSetting, hotelID string) (chan *geoCheckResult, chan string) {
	resultChannel := make(chan *geoCheckResult)
	permalinkChannel := make(chan string)
	go func() {
		defer close(resultChannel)
		defer close(permalinkChannel)
		res := checkHotelStatusInGeoImpl(partner, hotelID)
		select {
		case resultChannel <- &res:
		case <-ctx.Done():
			return
		}
		select {
		case permalinkChannel <- res.Permalink:
		case <-ctx.Done():
			return
		}
	}()
	return resultChannel, permalinkChannel
}
