package core

import (
	"a.yandex-team.ru/travel/hotels/tools/boy_hotels_checker/pkg/utils"
	"net/url"
)

func getOauthToken(clientID string, clientSecret string) (string, error) {
	data := url.Values{}
	data.Add("client_id", clientID)
	data.Add("client_secret", clientSecret)
	data.Add("grant_type", "client_credentials")
	parsed, err := utils.HTTPPostForm(oauthAPI.Value, data)
	if err != nil {
		return "", err
	}
	token := string(parsed.GetStringBytes("access_token"))
	return token, nil
}
