-- EXPORT mappings lib
PRAGMA SimpleColumns;
USE hahn;
$workdir = "//home/travel/prod/general/altay_mappings/latest/";

DEFINE SUBQUERY $filter_hotel_permalinks_all($data) AS
    $hotels_permalinks = $workdir || "extras/hotels_permalinks_all";
    SELECT
        data.*
    FROM
        $data() AS data
        JOIN
        $hotels_permalinks AS hp
        USING (permalink);
END DEFINE;

DEFINE SUBQUERY $filter_hotel_permalinks_published($data) AS
    $hotels_permalinks = $workdir || "hotels_permalinks_published";
    SELECT
        data.*
    FROM
        $data() AS data
        JOIN
        $hotels_permalinks AS hp
        USING (permalink);
END DEFINE;

DEFINE SUBQUERY $map_cluster_permalinks($data) AS
    $permalink_to_cluster_permalink = $workdir || "permalink_to_cluster_permalink";
    SELECT
        kostyl.cluster_permalink AS permalink,
        kostyl.* without permalink, cluster_permalink
    FROM (
        SELECT
            *
        FROM
            $data() AS data
            JOIN
            $permalink_to_cluster_permalink AS p2cp
            USING (permalink)
        ) AS kostyl;
END DEFINE;

DEFINE SUBQUERY $map_cluster_permalinks_filtered($data) AS
    $permalink_to_cluster_permalink = $workdir || "extras/permalink_to_cluster_permalink_filtered";
    SELECT
        kostyl.cluster_permalink AS permalink,
        kostyl.* without permalink, cluster_permalink
    FROM (
        SELECT
            *
        FROM
            $data() AS data
            JOIN
            $permalink_to_cluster_permalink AS p2cp
            USING (permalink)
        ) AS kostyl;
END DEFINE;


DEFINE SUBQUERY $map_originalid_to_permalink($data) AS
-- uses accumulated mapping to be able to map any partnerid_originalid in history
    $originalid_to_permalink = $workdir || "partnerid_originalid_to_cluster_permalink";
    SELECT
        kostyl.*
    FROM (
        SELECT * FROM
            $data() AS data
            JOIN
            $originalid_to_permalink AS oi2p
            USING (partnerid, originalid)
        ) AS kostyl;
END DEFINE;

DEFINE SUBQUERY $map_permalink_to_originalid($data) AS
    $permalink_to_originalid = $workdir || "permalink_to_partnerid_originalid";
    SELECT
        *
    FROM
        $data() AS data
        JOIN
        $permalink_to_originalid AS p2oi
        USING (permalink);
END DEFINE;

EXPORT $filter_hotel_permalinks_all, $filter_hotel_permalinks_published, $map_cluster_permalinks, $map_cluster_permalinks_filtered, $map_originalid_to_permalink, $map_permalink_to_originalid;
---------------------------------------------------------------------------------------
-- usage
-- look at example.yql for example of export
