# coding=utf-8

from library.python import resource
from travel.hotels.lib.python import yqllib
from travel.hotels.lib.python.versioned_process import VersionedProcess

from yql.api.v1.client import YqlClient


class HotelTraitsDataBuilder(VersionedProcess):
    name = 'hotel_traits'
    category_name = 'factors'

    '''
        HOTELS-4366  free_cancellation
        HOTELS-4367  breakfast_included
        HOTELS-4371  feagen
        HOTELS-4684  price_category
    '''

    @staticmethod
    def configure_arg_parser(parser, proc_env):
        arg_group = parser.add_argument_group(HotelTraitsDataBuilder.name)
        arg_group.add_argument('--min-region-price-count', default=100)
        arg_group.add_argument('--cluster-permalink-prices',)
        arg_group.add_argument('--yql-token')

    def __init__(self, session, args):
        super(HotelTraitsDataBuilder, self).__init__(session, args)
        self.yql_client = YqlClient(token=args.yql_token, db=args.yt_proxy)
        self.min_region_price_count = args.min_region_price_count
        self.cluster_permalink_prices = args.cluster_permalink_prices

    def run_query(self, query, parameters=None, debug=None):
        if debug is None:
            debug = self.debug
        return yqllib.run_query(query=query, parameters=parameters, client=self.yql_client,
                                debug=debug, syntax_version=1)

    def wait_results(self, query, parameters=None):
        request = self.run_query(query, parameters)
        yqllib.wait_results(request)

    def run(self):
        output = self.get_table_path(self.name)

        traits_table = output + '_traits'
        prices_table = output + '_prices'
        places_nearby_table = output + '_places_nearby'
        urls_table = output + '_urls'

        traits_query = self.run_query(
            resource.find('hotel_traits.yql'),
            parameters={
                '$output_path': traits_table,
            },
        )
        prices_query = self.run_query(
            resource.find('price_category.yql'),
            parameters={
                '$min_region_price_count': self.min_region_price_count,
                '$cluster_permalink_prices': self.cluster_permalink_prices,
                '$output_path': prices_table,
            },
        )
        places_nearby_query = self.run_query(
            resource.find('places_nearby.yql'),
            parameters={
                '$output_path': places_nearby_table,
            },
        )
        urls_query = self.run_query(
            resource.find('ya_travel_booking_links.yql'),
            parameters={
                '$output_path': urls_table,
            }
        )
        yqllib.wait_results(
            traits_query,
            prices_query,
            places_nearby_query,
            urls_query,
        )

        self.wait_results(
            query=resource.find('collect.yql'),
            parameters={
                '$traits_table': traits_table,
                '$prices_table': prices_table,
                '$places_nearby_table': places_nearby_table,
                '$urls_table': urls_table,
                '$result_table': output,
            }
        )


if __name__ == '__main__':
    HotelTraitsDataBuilder.main()
