# -*- coding: utf-8 -*-

from datetime import datetime
from typing import Any, Dict, List

from travel.hotels.tools.check_nirvana_logs.oauth_client import OauthClient


JsonDict = Dict[str, Any]
Data = List[JsonDict]


class HitmanClient(object):

    def __init__(self, token: str) -> None:
        self.session = OauthClient.get_session(token)
        self.api_url = 'https://hitman.yandex-team.ru/api/v2/'

    @staticmethod
    def timestamp(dt: datetime):
        return int((dt - datetime(1970, 1, 1, tzinfo=dt.tzinfo)).total_seconds()) * 1000

    def get_project_processes(self, project_code: str) -> Data:
        url = '{}project/{}/processes'.format(self.api_url, project_code)
        rsp = self.session.get(url)
        rsp.raise_for_status()

        return rsp.json()

    def get_process_jobs(self, process_code: str, status: str = None, date_from: datetime = None) -> Data:
        url = '{}process/{}/jobs'.format(self.api_url, process_code)

        params = dict()
        if status is not None:
            params['status'] = status
        if date_from is not None:
            params['fromTs'] = self.timestamp(date_from)

        rsp = self.session.get(url, params=params)
        rsp.raise_for_status()

        return rsp.json()
