# -*- coding: utf-8 -*-

from typing import Dict

from travel.hotels.tools.check_nirvana_logs.oauth_client import OauthClient


class NirvanaClient(object):

    def __init__(self, token: str) -> None:
        self.session = OauthClient.get_session(token)
        self.api_url = 'https://nirvana.yandex-team.ru/api/public/v1/'

    def get_workflow_logs(self, workflow_uid: str) -> Dict[str, str]:
        url = self.api_url + 'getBlockLogs'
        params = {
            'workflowId': workflow_uid,
        }
        rsp = self.session.get(url, params=params)
        rsp.raise_for_status()

        logs = dict()
        for block in rsp.json()['result']:
            code = block['blockCode']
            for log in block['logs']:
                log_name = '{}_{}'.format(code, log['logName'])
                logs[log_name] = log['storagePath']
        return logs
