# -*- coding: utf-8 -*-

from typing import Optional

from requests import Session
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util import Retry


class OauthClient(object):

    @staticmethod
    def get_session(token: Optional[str] = None) -> Session:
        session = Session()

        retry = Retry(
            total=15,
            backoff_factor=1.0,
            status_forcelist=frozenset([500, 503, 413, 429]),
        )

        session.mount('http://', HTTPAdapter(max_retries=retry))
        session.mount('https://', HTTPAdapter(max_retries=retry))

        if token is not None:
            session.headers.update({'Authorization': f'OAuth {token}'})

        return session
