import requests
import json

from requests import HTTPError


class HotelsApiClient(object):
    def __init__(self, host, port, ticket):
        self.host = host
        self.port = port
        self.ticket = ticket

    def get_url(self, method):
        return "http://{}:{}/api/{}".format(self.host, self.port, method)

    def suggest(self, query):
        try:
            res = self.get("suggest/v1", query=query)
            return json.loads(res)
        except:
            return []

    def search_serp(self, search_object, checkin, checkout, num_adults, children):
        searchMethodName = search_object['request_template']['method_name']
        params = search_object['request_template']['params']
        params["checkin_date"] = checkin
        params["checkout_date"] = checkout
        params["num_adults"] = num_adults
        params["children_ages"] = ",".join(children)
        json_resp = json.loads(self.get(searchMethodName, **params))
        return json_resp['url'], json_resp["text_template"], json_resp['redirect_timeout']

    def search_region_on_portal(self, region_name, checkin=None, checkout=None, num_adults=None, children=None,
                                operators=None, limit=None):
        return json.loads(self.get("search/portal/multi/v1",
                                   location_name=region_name,
                                   checkin_date=checkin,
                                   checkout_date=checkout,
                                   num_adults=num_adults,
                                   children_ages=children,
                                   operator=operators,
                                   limit=limit))

    def search_hotel_on_portal(self, permalink, checkin=None, checkout=None, num_adults=None, children=None,
                               operators=None, limit=None):
        return json.loads(self.get("search/portal/single/v1",
                                   permalink=permalink,
                                   checkin_date=checkin,
                                   checkout_date=checkout,
                                   num_adults=num_adults,
                                   children_ages=children,
                                   operator=operators,
                                   limit=limit))

    def get_offer_by_token(self, label, token):
        return json.loads(self.get("booking_flow/v1/get_order_info_by_token",
                                   token=token,
                                   label=label,
                                   customerIp="127.0.0.1",
                                   customerUserAgent="travelHotelsCli/1.0"))

    def create_order(self, token, label, checksum, login, uid, passport_id, session_key, bg_index, email, phone, gdpr,
                     guests):
        data = {
            "token": token,
            "label": label,
            "checksum": checksum,
            "customer_ip": "127.0.0.1",
            "customer_user_agent": "travelHotelsCli/1.0",
            "customer_yandex_uid": uid,
            "customer_passport_id": passport_id,
            "customer_login": login,
            "session_key": session_key,
            "selected_bed_group_index": bg_index,
            "customer_email": email,
            "customer_phone": phone,
            "allows_subscription": gdpr
        }
        guests_objs = []
        for guest in guests:
            g = {"first_name": guest["first_name"], "last_name": guest["last_name"]}
            guests_objs.append(g)
        data["guests"] = guests_objs
        return json.loads(self.post("booking_flow/v1/create_order", data))["id"]

    def get_order(self, id):
        try:
            return json.loads(self.get("booking_flow/v1/get_order", id=id))
        except HTTPError as ex:
            if ex.response.status_code == 404:
                return None

    def start_payment(self, id, return_url):
        data = {
            "order_id": id,
            "return_url": return_url
        }
        self.post("booking_flow/v1/start_payment", data)

    def get(self, endpoint, **kwargs):
        url = self.get_url(endpoint)
        headers = {'X-Ya-Service-Ticket': self.ticket}
        resp = requests.get(url, params=kwargs, headers=headers)
        if resp.status_code == 200:
            return resp.content
        else:
            print(resp.content)
            resp.raise_for_status()

    def post(self, endpoint, data):
        url = self.get_url(endpoint)
        headers = {'X-Ya-Service-Ticket': self.ticket}
        resp = requests.post(url, json=data, headers=headers)
        if resp.status_code == 200:
            return resp.content
        else:
            print(resp.content)
            resp.raise_for_status()
