# coding=utf-8
from travel.hotels.tools.cli import tableprinter


class Command(object):
    name = ""

    def __init__(self, subparsers):
        self.sub_parser = subparsers.add_parser(self.name)
        self.sub_parser.set_defaults(func=self.handle)
        self.add_arguments()
        self.client = None

    def get_column_mappings(self):
        return None

    def add_arguments(self):
        pass

    def execute(self, args):
        pass

    def map_output(self, item):
        return item

    def handle(self, args):
        res = self.map_output(self.execute(args))

        self.print_results(res)

    def print_results(self, res):
        if isinstance(res, str) or isinstance(res, unicode):
            print(res)
        else:
            tableprinter.print_table(res, self.get_column_mappings())

    def set_client(self, client):
        self.client = client


class ListCommand(Command):
    def map_output(self, items):
        return [self.map_item(i) for i in items]

    def map_item(self, item):
        return item
