# coding=utf-8
import base
from travel.hotels.tools.cli import tableprinter


class SearchRegionCommand(base.ListCommand):
    name = "search-region"

    def add_arguments(self):
        self.sub_parser.add_argument("region")
        self.sub_parser.add_argument("--checkin")
        self.sub_parser.add_argument("--checkout")
        self.sub_parser.add_argument("--num-adults")
        self.sub_parser.add_argument("--child", action="append")
        self.sub_parser.add_argument("--operator", action="append")

    def execute(self, args):
        return self.client.search_region_on_portal(args.region, args.checkin, args.checkout, args.num_adults,
                                                   args.child, args.operator).get("hotels")

    def get_column_mappings(self):
        return [("permalink", "id"), ("name", u"Название"), ("address", u"Адрес"), ("min_price", u"Цена от, руб")]

    def map_item(self, item):
        item["min_price"] = item["min_price"]["price"] if "min_price" in item and item["min_price"] is not None \
            else None
        return item


class SearchHotelCommand(base.Command):
    name = "search-hotel"

    def add_arguments(self):
        self.sub_parser.add_argument("permalink")
        self.sub_parser.add_argument("--checkin")
        self.sub_parser.add_argument("--checkout")
        self.sub_parser.add_argument("--num-adults")
        self.sub_parser.add_argument("--child", action="append")
        self.sub_parser.add_argument("--operator", action="append")

    def execute(self, args):
        res = self.client.search_hotel_on_portal(args.permalink, args.checkin, args.checkout, args.num_adults,
                                                 args.child, args.operator).get("hotels")
        if not res:
            return None
        else:
            return res[0]

    def get_order_column_mappings(self):
        return [("room_type", u"Номер"), ("operator_name", u"Оператор"), ("pansion", u"Еда"),
                ("free_cancellation", u"Отменяемый"), ("price", u"Цена, руб")]

    def get_hotel_column_mappings(self):
        return [("permalink", "id"), ("name", u"Название"), ("address", u"Адрес"), ("min_price", u"Цена от, руб")]

    def print_results(self, res):
        if not res:
            print("Ничего не найдено")
        else:
            print("Отель")
            res["min_price"] = res["min_price"]["price"] if "min_price" in res and res["min_price"] is not None \
                else None
            tableprinter.print_table(res, self.get_hotel_column_mappings())
            if res["offers"]:
                print("Номера")
                tableprinter.print_table(res["offers"], self.get_order_column_mappings())
            else:
                print("Номеров не найдено")
