# coding=utf-8
import base


class SuggestCommand(base.ListCommand):
    name = "suggest"

    def add_arguments(self):
        self.sub_parser.add_argument("query")

    def execute(self, args):
        return self.client.suggest(args.query)

    def map_item(self, item):
        try:
            item["permalink"] = item["request_template"]["params"]["permalink"]
            return item
        except Exception:
            return item

    def get_column_mappings(self):
        return [("name", u"Название"), ("type_name", u"Тип"), ("description", u"Описание"), ("permalink", "id")]
