# coding=utf-8
import types
import collections
import prettytable


def print_table(obj, field_mappings=None):
    if isinstance(field_mappings, types.DictType):
        field_mappings = field_mappings.items()

    if isinstance(obj, types.DictType):
        column_names = [u'Поле', u'Значение']
        table = prettytable.PrettyTable(column_names)
        table.align[column_names[0]] = "r"
        table.align[column_names[1]] = "l"
        if field_mappings:
            for field_name, field_title in field_mappings:
                value = obj.get(field_name)
                table.add_row([field_title, value])
        else:
            for k, v in obj.iteritems():
                if k.startswith("_hid"):
                    k = ""
                table.add_row([k, v])
    elif isinstance(obj, collections.Iterable):
        if field_mappings:
            table = prettytable.PrettyTable([name for _, name in field_mappings])
            table.align[field_mappings[0][0]] = "l"
        else:
            table = prettytable.PrettyTable(header=False)
        for o in obj:
            if o is None:
                continue
            if not isinstance(o, types.DictType):
                raise Exception("Object '{}' in result is not a dictionary".format(o))
            if field_mappings:
                row = []
                for field_name, _ in field_mappings:
                    if not isinstance(field_name, list):
                        field_name = [field_name]
                    val = o
                    for key in field_name:
                        val = val.get(key)
                    row.append(val)
            else:
                row = o.values()
            table.add_row(row)
    else:
        print("Object is neither dict nor iterable")
        return

    print(table)
