from ticket_parser2.api.v1 import TvmClient, TvmClientStatus, TvmApiClientSettings


def make_tvm_client(client_id, secret, destinations):
    settings = TvmApiClientSettings(
        self_client_id=client_id,
        enable_service_ticket_checking=True,
        enable_user_ticket_checking=False,
        self_secret=secret,
        dsts=destinations,
    )
    client = TvmClient(settings)
    if client.status != TvmClientStatus.Ok:
        raise Exception("tvm client has bad status: " + TvmClient.status_to_string(client.status))
    return client
