import argparse
from yql.api.v1.client import YqlClient
from yt.wrapper import YtClient
from travel.hotels.lib.python3.yql import yqllib
from travel.hotels.lib.python3.yt import ytlib
from travel.library.python.tools import replace_args_from_env


class Runner(object):

    def __init__(self, args):
        yql_args = {
            'db': args.yt_proxy,
            'token': args.yql_token
        }
        self.yql_client = YqlClient(**yql_args)
        yt_config = {
            'token': args.yt_token,
            'token_path': args.yt_token_path,
        }
        self.yt_client = YtClient(proxy=args.yt_proxy, config=yt_config)
        self.args = args

    def run(self):
        self._ensure_yt_dir(self.args.output_path)
        clustered_hotels_table = ytlib.join(self.args.output_path, 'clustered_hotels')
        yqllib.run_yql_file(
            self.yql_client,
            'clustering_query.yql',
            'ClusteredHotelsUpdater',
            parameters={
                '$clustered_hotels_table': clustered_hotels_table
            }
        )

    def _ensure_yt_dir(self, yt_path):
        self.yt_client.create('map_node', yt_path, recursive=True, ignore_existing=True)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--yt-token')
    parser.add_argument('--yt-token-path')
    parser.add_argument('--yql-token', required=True)
    parser.add_argument('--output-path', required=True)
    args = parser.parse_args(args=replace_args_from_env())
    Runner(args).run()


if __name__ == '__main__':
    main()
